package forestry.arboriculture.blocks;

import java.util.Collections;
import java.util.List;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.core.proxy.Proxies;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCharcoal extends Block implements IStateMapperRegister, IItemModelRegister {

	public static final PropertyInteger AMOUNT = PropertyInteger.func_177719_a("amount", 0, 15);
	
	public BlockCharcoal() {
		super(Material.field_151576_e, MapColor.field_151646_E);
		func_149711_c(5.0F);
		func_149752_b(10.0F);
		func_149672_a(SoundType.field_185851_d);
		func_149647_a(Tabs.tabArboriculture);
	}
	
	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, AMOUNT);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		manager.registerItemModel(item, 0);
	}
	
	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(AMOUNT);
	}
	
	@Override
	public IBlockState func_176203_a(int meta) {
		return func_176223_P().func_177226_a(AMOUNT, meta);
	}
	
	@Override
	public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
		if(state.func_177229_b(AMOUNT) > 0){
			return Collections.singletonList(new ItemStack(Items.field_151044_h, state.func_177229_b(AMOUNT) + 9, 1));
		}
		return super.getDrops(world, pos, state, fortune);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerStateMapper() {
		Proxies.render.registerStateMapper(this, new StateMap.Builder().func_178442_a(AMOUNT).func_178441_a());
	}

}
