/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.items;

import java.util.List;

import forestry.api.apiculture.DefaultBeeModifier;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.Tabs;
import forestry.core.items.ItemForestry;
import forestry.core.utils.Translator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemHiveFrame extends ItemForestry implements IHiveFrame {

	private final HiveFrameBeeModifier beeModifier;

	public ItemHiveFrame(int maxDamage, float geneticDecay) {
		func_77625_d(1);
		func_77656_e(maxDamage);
		func_77637_a(Tabs.tabApiculture);

		this.beeModifier = new HiveFrameBeeModifier(geneticDecay);
	}

	@Override
	public ItemStack frameUsed(IBeeHousing housing, ItemStack frame, IBee queen, int wear) {
		frame.func_77964_b(frame.func_77952_i() + wear);
		if (frame.func_77952_i() >= frame.func_77958_k()) {
			return ItemStack.field_190927_a;
		} else {
			return frame;
		}
	}

	@Override
	public IBeeModifier getBeeModifier() {
		return beeModifier;
	}

	@Override
	public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
		super.func_77624_a(stack, playerIn, tooltip, advanced);
		beeModifier.addInformation(stack, playerIn, tooltip, advanced);
		if (!stack.func_77951_h()) {
			tooltip.add(Translator.translateToLocalFormatted("item.for.durability", stack.func_77958_k()));
		}
	}

	private static class HiveFrameBeeModifier extends DefaultBeeModifier {
		private static final float production = 2f;
		private final float geneticDecay;

		public HiveFrameBeeModifier(float geneticDecay) {
			this.geneticDecay = geneticDecay;
		}

		@Override
		public float getProductionModifier(IBeeGenome genome, float currentModifier) {
			return currentModifier < 10f ? production : 1f;
		}

		@Override
		public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
			return this.geneticDecay;
		}

		public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
			tooltip.add(Translator.translateToLocalFormatted("item.for.bee.modifier.production", production));
			tooltip.add(Translator.translateToLocalFormatted("item.for.bee.modifier.genetic.decay", geneticDecay));
		}
	}
}
