/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.blocks;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileUtil;
import forestry.lepidopterology.blocks.CocoonStateMapper;
import forestry.lepidopterology.blocks.MaterialCocoon;
import forestry.lepidopterology.blocks.PropertyCocoon;
import forestry.lepidopterology.genetics.alleles.AlleleButterflyCocoon;
import forestry.lepidopterology.genetics.alleles.ButterflyAlleles;
import forestry.lepidopterology.tiles.TileCocoon;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCocoon
extends Block
implements ITileEntityProvider,
IStateMapperRegister,
IItemModelRegister {
    public static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 1.0, 0.6875);
    private static final PropertyCocoon COCOON = AlleleButterflyCocoon.COCOON;

    public BlockCocoon() {
        super((Material)new MaterialCocoon());
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)COCOON, (Comparable)ButterflyAlleles.cocoonDefault).func_177226_a((IProperty)AlleleButterflyCocoon.AGE, (Comparable)Integer.valueOf(0)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COCOON, AlleleButterflyCocoon.AGE});
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileCocoon cocoon = TileUtil.getTile(world, pos, TileCocoon.class);
        if (cocoon != null) {
            state = state.func_177226_a((IProperty)COCOON, (Comparable)cocoon.getCaterpillar().getGenome().getCocoon()).func_177226_a((IProperty)AlleleButterflyCocoon.AGE, (Comparable)Integer.valueOf(cocoon.getAge()));
        }
        return super.func_176221_a(state, world, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        Proxies.render.registerStateMapper(this, new CocoonStateMapper());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0, "cocoon_late");
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        TileCocoon tileCocoon = TileUtil.getTile((IBlockAccess)world, pos, TileCocoon.class);
        if (tileCocoon == null) {
            return;
        }
        if (tileCocoon.func_145837_r()) {
            return;
        }
        if ((double)world.field_73012_v.nextFloat() > 0.1) {
            return;
        }
        tileCocoon.onBlockTick();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCocoon(false);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175698_g(pos);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileCocoon tile = TileUtil.getTile((IBlockAccess)world, pos, TileCocoon.class);
        if (tile == null) {
            return ItemStack.field_190927_a;
        }
        IButterfly caterpillar = tile.getCaterpillar();
        int age = tile.getAge();
        ItemStack stack = ButterflyManager.butterflyRoot.getMemberStack(caterpillar, EnumFlutterType.COCOON);
        if (!stack.func_190926_b() && stack.func_77978_p() != null) {
            stack.func_77978_p().func_74768_a("Age", age);
        }
        return stack;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return BOUNDING_BOX.func_186670_a(pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }
}

