/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.network.packets;

import java.io.IOException;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class PacketTileStream extends ForestryPacket implements IForestryPacketClient {
	private final BlockPos pos;
	private final IStreamable streamable;

	public <T extends TileEntity & IStreamable> PacketTileStream(T streamable) {
		this.pos = streamable.func_174877_v();
		this.streamable = streamable;
	}

	@Override
	public PacketIdClient getPacketId() {
		return PacketIdClient.TILE_FORESTRY_UPDATE;
	}

	@Override
	protected void writeData(PacketBufferForestry data) {
		data.func_179255_a(pos);
		streamable.writeData(data);
	}

	public static class Handler implements IForestryPacketHandlerClient {
		@Override
		public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
			BlockPos pos = data.func_179259_c();
			TileEntity tile = player.field_70170_p.func_175625_s(pos);
			if (tile instanceof IStreamable) {
				((IStreamable) tile).readData(data);
			}
		}
	}
}
