/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui;

import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.greenhouse.gui.GuiGreenhouse;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetClimatePillar
extends Widget {
    private final List<ClimateButton> buttons = new ArrayList<ClimateButton>();

    public WidgetClimatePillar(WidgetManager manager, int xPos, int yPos) {
        super(manager, xPos, yPos);
        this.width = 23;
        this.height = 90;
        for (int i = 1; i < 6; ++i) {
            float value;
            EnumTemperature temp = EnumTemperature.VALUES[i];
            switch (temp) {
                case ICY: {
                    value = 0.0f;
                    break;
                }
                case COLD: {
                    value = 0.2f;
                    break;
                }
                case WARM: {
                    value = 0.9f;
                    break;
                }
                case HOT: {
                    value = 1.2f;
                    break;
                }
                default: {
                    value = 0.5f;
                }
            }
            this.buttons.add(new ClimateButton(this, temp, value, xPos + 5, yPos + 5 + (i - 1) * 16));
        }
    }

    @Override
    public void draw(int startX, int startY) {
        Proxies.render.bindTexture(this.manager.gui.textureFile);
        this.manager.gui.func_73729_b(startX + this.xPos, startY + this.yPos, 216, 25, this.width, this.height);
        for (ClimateButton button : this.buttons) {
            button.draw(startX, startY);
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        for (ClimateButton button : this.buttons) {
            if (!button.isMouseOver(mouseX, mouseY)) continue;
            return button.getToolTip();
        }
        return null;
    }

    @Override
    public boolean handleMouseRelease(int mouseX, int mouseY, int eventType) {
        return this.isMouseOver(mouseX -= this.manager.gui.getGuiLeft(), mouseY -= this.manager.gui.getGuiTop());
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        mouseX -= this.manager.gui.getGuiLeft();
        mouseY -= this.manager.gui.getGuiTop();
        for (ClimateButton button : this.buttons) {
            if (!button.isMouseOver(mouseX, mouseY)) continue;
            ((GuiGreenhouse)this.manager.gui).setClimate(button.value);
        }
    }

    protected void drawSprite(TextureAtlasSprite sprite, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Proxies.render.bindTexture(TextureManager.getInstance().getGuiTextureMap());
        this.manager.gui.func_175175_a(x, y, sprite, 16, 16);
    }

    private static class ClimateButton {
        final WidgetClimatePillar parent;
        final EnumTemperature temperature;
        final float value;
        final int xPos;
        final int yPos;
        protected final ToolTip toolTip = new ToolTip(250){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void refresh() {
                toolTip.clear();
                toolTip.add("T: " + AlleleManager.climateHelper.toDisplay(temperature));
                toolTip.add("V: " + value);
            }
        };

        public ClimateButton(WidgetClimatePillar parent, EnumTemperature temperature, float value, int xPos, int yPos) {
            this.parent = parent;
            this.temperature = temperature;
            this.value = value;
            this.xPos = xPos;
            this.yPos = yPos;
        }

        public void draw(int startX, int startY) {
            this.parent.drawSprite(this.temperature.getSprite(), startX + this.xPos, startY + this.yPos);
        }

        public ToolTip getToolTip() {
            return this.toolTip;
        }

        public boolean isMouseOver(int mouseX, int mouseY) {
            return mouseX >= this.xPos && mouseX <= this.xPos + 16 && mouseY >= this.yPos && mouseY <= this.yPos + 16;
        }
    }
}

