/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.network.packets;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.factory.recipes.MemorizedRecipe;
import forestry.factory.tiles.TileWorktable;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class PacketWorktableRecipeUpdate
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    @Nullable
    private final MemorizedRecipe recipe;

    public PacketWorktableRecipeUpdate(TileWorktable worktable) {
        this.pos = worktable.func_174877_v();
        this.recipe = worktable.getCurrentRecipe();
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.WORKTABLE_CRAFTING_UPDATE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.pos);
        data.writeStreamable(this.recipe);
    }

    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            BlockPos pos = data.func_179259_c();
            MemorizedRecipe recipe = data.readStreamable(MemorizedRecipe::new);
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (tile instanceof TileWorktable) {
                ((TileWorktable)tile).setCurrentRecipe(recipe);
            }
        }
    }
}

