/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.CamouflageSelectionType;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class PacketCamouflageSelectClient
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final ItemStack camouflageStack;
    private final String camouflageType;
    private final CamouflageSelectionType selectionType;

    public PacketCamouflageSelectClient(ICamouflageHandler handler, String camouflageType, CamouflageSelectionType selectionType) {
        this.pos = handler.getCoordinates();
        this.camouflageStack = handler.getCamouflageBlock(camouflageType);
        this.selectionType = selectionType;
        this.camouflageType = camouflageType;
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.CAMOUFLAGE_SELECTION;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        data.writeShort(this.selectionType.ordinal());
        data.func_180714_a(this.camouflageType);
        data.func_150788_a(this.camouflageStack);
    }

    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            ICamouflageHandler handler;
            BlockPos pos = data.func_179259_c();
            CamouflageSelectionType selectionType = CamouflageSelectionType.values()[data.readShort()];
            String camouflageType = data.readString();
            ItemStack camouflageStack = data.func_150791_c();
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (selectionType == CamouflageSelectionType.MULTIBLOCK) {
                ICamouflageHandler handler2;
                IMultiblockController controller;
                if (tile instanceof IMultiblockComponent && (controller = ((IMultiblockComponent)tile).getMultiblockLogic().getController()) instanceof ICamouflageHandler && (handler2 = (ICamouflageHandler)((Object)controller)).setCamouflageBlock(camouflageType, camouflageStack, false)) {
                    for (IMultiblockComponent comp : controller.getComponents()) {
                        ICamouflagedTile camBlock;
                        if (!(comp instanceof ICamouflagedTile) || !(camBlock = (ICamouflagedTile)((Object)comp)).getCamouflageType().equals(camouflageType)) continue;
                        player.field_70170_p.func_175704_b(camBlock.getCoordinates(), camBlock.getCoordinates());
                    }
                }
            } else if (selectionType == CamouflageSelectionType.TILE && tile instanceof ICamouflageHandler && (handler = (ICamouflageHandler)tile).setCamouflageBlock(camouflageType, camouflageStack, false)) {
                player.field_70170_p.func_175704_b(pos, pos);
            }
        }
    }
}

