/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.fluids.StandardTank;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Translator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FilteredTank
extends StandardTank {
    private final Set<String> filters = new HashSet<String>();

    public FilteredTank(int capacity) {
        super(capacity);
    }

    public FilteredTank(int capacity, boolean canFill, boolean canDrain) {
        super(capacity, canFill, canDrain);
    }

    public FilteredTank setFilters(Fluid ... filters) {
        return this.setFilters(Arrays.asList(filters));
    }

    public FilteredTank setFilters(Collection<Fluid> filters) {
        this.filters.clear();
        for (Fluid fluid : filters) {
            this.filters.add(fluid.getName());
        }
        return this;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.fluidMatchesFilter(fluid);
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return this.fluidMatchesFilter(fluid);
    }

    private boolean fluidMatchesFilter(FluidStack resource) {
        return resource != null && resource.getFluid() != null && this.filters.contains(resource.getFluid().getName());
    }

    @Override
    protected void refreshTooltip() {
        if (this.hasFluid()) {
            super.refreshTooltip();
            return;
        }
        this.toolTip.clear();
        if (Proxies.common.isShiftDown() || this.filters.size() < 5) {
            for (String filterName : this.filters) {
                Fluid fluidFilter = FluidRegistry.getFluid((String)filterName);
                EnumRarity rarity = fluidFilter.getRarity();
                if (rarity == null) {
                    rarity = EnumRarity.COMMON;
                }
                FluidStack filterFluidStack = FluidRegistry.getFluidStack((String)fluidFilter.getName(), (int)0);
                this.toolTip.add(fluidFilter.getLocalizedName(filterFluidStack), rarity.field_77937_e);
            }
        } else {
            this.toolTip.add(TextFormatting.ITALIC + "<" + Translator.translateToLocal("for.gui.tooltip.tmi") + ">");
        }
        String liquidAmount = Translator.translateToLocalFormatted("for.gui.tooltip.liquid.amount", this.getFluidAmount(), this.getCapacity());
        this.toolTip.add(liquidAmount);
    }
}

