/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.tiles;

import java.io.IOException;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.core.gui.ContainerEscritoire;
import forestry.core.gui.GuiEscritoire;
import forestry.core.inventory.InventoryAnalyzer;
import forestry.core.inventory.InventoryEscritoire;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketItemStackDisplay;
import forestry.core.proxy.Proxies;
import forestry.core.utils.InventoryUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEscritoire extends TileBase implements ISidedInventory, ISlotPickupWatcher, IStreamableGui, IItemStackDisplay {

	private final EscritoireGame game = new EscritoireGame();
	private ItemStack individualOnDisplayClient = ItemStack.field_190927_a;

	public TileEscritoire() {
		setInternalInventory(new InventoryEscritoire(this));
	}

	/* SAVING & LOADING */
	@Override
	public void func_145839_a(NBTTagCompound nbttagcompound) {
		super.func_145839_a(nbttagcompound);
		game.readFromNBT(nbttagcompound);
	}


	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
		nbttagcompound = super.func_189515_b(nbttagcompound);
		game.writeToNBT(nbttagcompound);
		return nbttagcompound;
	}

	/* GAME */
	public EscritoireGame getGame() {
		return game;
	}

	public void choose(GameProfile gameProfile, int index) {
		game.choose(index);
		processTurnResult(gameProfile);
	}

	private void processTurnResult(GameProfile gameProfile) {
		if (getGame().getStatus() != EscritoireGame.Status.SUCCESS) {
			return;
		}

		IIndividual individual = AlleleManager.alleleRegistry.getIndividual(func_70301_a(InventoryEscritoire.SLOT_ANALYZE));
		if (individual == null) {
			return;
		}

		IAlleleSpecies species = individual.getGenome().getPrimary();
		for (ItemStack itemstack : species.getResearchBounty(field_145850_b, gameProfile, individual, game.getBountyLevel())) {
			InventoryUtil.addStack(getInternalInventory(), itemstack, InventoryEscritoire.SLOT_RESULTS_1, InventoryEscritoire.SLOTS_RESULTS_COUNT, true);
		}
	}

	private boolean areProbeSlotsFilled() {
		int filledSlots = 0;
		int required = game.getSampleSize(InventoryEscritoire.SLOTS_INPUT_COUNT);
		for (int i = InventoryEscritoire.SLOT_INPUT_1; i < InventoryEscritoire.SLOT_INPUT_1 + required; i++) {
			if (!func_70301_a(i).func_190926_b()) {
				filledSlots++;
			}
		}

		return filledSlots >= required;
	}

	public void probe() {
		if (field_145850_b.field_72995_K) {
			return;
		}

		ItemStack analyze = func_70301_a(InventoryEscritoire.SLOT_ANALYZE);

		if (!analyze.func_190926_b() && areProbeSlotsFilled()) {
			game.probe(analyze, this, InventoryEscritoire.SLOT_INPUT_1, InventoryEscritoire.SLOTS_INPUT_COUNT);
		}
	}

	/* NETWORK */
	@Override
	public void writeGuiData(PacketBufferForestry data) {
		game.writeData(data);
	}

	@Override
	public void readGuiData(PacketBufferForestry data) throws IOException {
		game.readData(data);
	}

	@Override
	public void writeData(PacketBufferForestry data) {
		super.writeData(data);
		ItemStack displayStack = getIndividualOnDisplay();
		data.func_150788_a(displayStack);
	}

	@Override
	public void readData(PacketBufferForestry data) throws IOException {
		super.readData(data);
		individualOnDisplayClient = data.func_150791_c();
	}

	/* ISlotPickupWatcher */
	@Override
	public void onTake(int slotIndex, EntityPlayer player) {
		if (slotIndex == InventoryEscritoire.SLOT_ANALYZE) {
			game.reset();
			PacketItemStackDisplay packet = new PacketItemStackDisplay(this, getIndividualOnDisplay());
			Proxies.net.sendNetworkPacket(packet, field_174879_c, field_145850_b);
		}
	}

	@Override
	public void func_70299_a(int slotIndex, ItemStack itemstack) {
		super.func_70299_a(slotIndex, itemstack);
		if (slotIndex == InventoryEscritoire.SLOT_ANALYZE) {
			PacketItemStackDisplay packet = new PacketItemStackDisplay(this, getIndividualOnDisplay());
			Proxies.net.sendNetworkPacket(packet, field_174879_c, field_145850_b);
		}
	}

	@Override
	public Object getGui(EntityPlayer player, int data) {
		return new GuiEscritoire(player, this);
	}

	@Override
	public Object getContainer(EntityPlayer player, int data) {
		return new ContainerEscritoire(player, this);
	}

	@Override
	public void handleItemStackForDisplay(ItemStack itemStack) {
		if (!ItemStack.func_77989_b(itemStack, individualOnDisplayClient)) {
			individualOnDisplayClient = itemStack;
			field_145850_b.func_175704_b(func_174877_v(), func_174877_v());
		}
	}

	public ItemStack getIndividualOnDisplay() {
		if (field_145850_b.field_72995_K) {
			return individualOnDisplayClient;
		}
		return func_70301_a(InventoryAnalyzer.SLOT_ANALYZE);
	}
}
