/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.render;

import javax.annotation.Nullable;

import forestry.apiculture.render.ModelAnalyzer;
import forestry.core.blocks.BlockBase;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileAnalyzer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class RenderAnalyzer extends TileEntitySpecialRenderer<TileAnalyzer> {

	private final ModelAnalyzer model;
	private final EntityItem dummyEntityItem = new EntityItem(null);
	private long lastTick;

	public RenderAnalyzer(String baseTexture) {
		this.model = new ModelAnalyzer(baseTexture);
	}

	/**
	 * @param analyzer If it null its render the item else it render the tile entity.
	 */
	@Override
	public void func_180535_a(TileAnalyzer analyzer, double x, double y, double z, float partialTicks, int destroyStage) {
		if (analyzer != null) {
			World worldObj = analyzer.getWorldObj();
			if (worldObj.func_175667_e(analyzer.func_174877_v())) {
				IBlockState blockState = worldObj.func_180495_p(analyzer.func_174877_v());
				if (blockState.func_177230_c() instanceof BlockBase) {
					EnumFacing facing = blockState.func_177229_b(BlockBase.FACING);
					render(analyzer.getIndividualOnDisplay(), analyzer.func_145831_w(), facing, x, y, z);
					return;
				}
			}
		}
		render(ItemStack.field_190927_a, null, EnumFacing.WEST, x, y, z);
	}

	private void render(ItemStack itemstack, @Nullable World world, EnumFacing orientation, double x, double y, double z) {

		dummyEntityItem.field_70170_p = world;

		model.render(orientation, (float) x, (float) y, (float) z);
		if (itemstack.func_190926_b() || world == null) {
			return;
		}
		float renderScale = 1.0f;

		GlStateManager.func_179094_E();
		GlStateManager.func_179109_b((float) x, (float) y, (float) z);
		GlStateManager.func_179109_b(0.5f, 0.2f, 0.5f);
		GlStateManager.func_179152_a(renderScale, renderScale, renderScale);
		dummyEntityItem.func_92058_a(itemstack);

		if (world.func_82737_E() != lastTick) {
			lastTick = world.func_82737_E();
			dummyEntityItem.func_70071_h_();
		}
		RenderManager rendermanager = Proxies.common.getClientInstance().func_175598_ae();

		rendermanager.func_188391_a(dummyEntityItem, 0.0D, 0.0D, 0.0D, 0.0F, 0.0F, false);
		GlStateManager.func_179121_F();

	}

}
