/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.base.Preconditions;
import forestry.api.core.IModelBaker;
import forestry.api.core.IModelBakerModel;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.models.baker.ModelBaker;
import forestry.core.proxy.Proxies;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class ModelBlockDefault<B extends Block, K>
implements IBakedModel {
    @Nullable
    private ItemOverrideList overrideList;
    protected final Class<B> blockClass;
    @Nullable
    protected IModelBakerModel blockModel;
    @Nullable
    protected IModelBakerModel itemModel;

    protected ModelBlockDefault(Class<B> blockClass) {
        this.blockClass = blockClass;
    }

    protected IBakedModel bakeModel(IBlockState state, K key, B block) {
        ModelBaker baker = new ModelBaker();
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState stateExtended = (IExtendedBlockState)state;
            IBlockAccess world = (IBlockAccess)stateExtended.getValue((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS);
            BlockPos blockPos = (BlockPos)stateExtended.getValue((IUnlistedProperty)UnlistedBlockPos.POS);
        }
        this.bakeBlock(block, key, baker, false);
        this.blockModel = baker.bakeModel(false);
        this.onCreateModel(this.blockModel);
        return this.blockModel;
    }

    protected IBakedModel getModel(IBlockState state) {
        Preconditions.checkArgument((boolean)this.blockClass.isInstance(state.func_177230_c()));
        K worldKey = this.getWorldKey(state);
        Block block = (Block)this.blockClass.cast(state.func_177230_c());
        return this.bakeModel(state, worldKey, block);
    }

    protected IBakedModel bakeModel(ItemStack stack, World world, K key) {
        ModelBaker baker = new ModelBaker();
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        Preconditions.checkArgument((boolean)this.blockClass.isInstance(block));
        Block bBlock = (Block)this.blockClass.cast(block);
        this.bakeBlock(bBlock, key, baker, true);
        this.itemModel = baker.bakeModel(true);
        return this.itemModel;
    }

    protected IBakedModel getModel(ItemStack stack, World world) {
        return this.bakeModel(stack, world, this.getInventoryKey(stack));
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        Preconditions.checkNotNull((Object)state);
        IBakedModel model = this.getModel(state);
        return model.func_188616_a(state, side, rand);
    }

    protected void onCreateModel(IModelBakerModel model) {
        model.setAmbientOcclusion(true);
    }

    public boolean func_177555_b() {
        return (this.itemModel != null || this.blockModel != null) && (this.blockModel != null ? this.blockModel.func_177555_b() : this.itemModel.func_177555_b());
    }

    public boolean func_177556_c() {
        return this.itemModel != null && this.itemModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return (this.itemModel != null || this.blockModel != null) && (this.blockModel != null ? this.blockModel.func_188618_c() : this.itemModel.func_188618_c());
    }

    public TextureAtlasSprite func_177554_e() {
        if (this.blockModel != null) {
            return this.blockModel.func_177554_e();
        }
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public ItemCameraTransforms func_177552_f() {
        if (this.itemModel == null) {
            return ItemCameraTransforms.field_178357_a;
        }
        return this.itemModel.func_177552_f();
    }

    protected ItemOverrideList createOverrides() {
        return new DefaultItemOverrideList();
    }

    public ItemOverrideList func_188617_f() {
        if (this.overrideList == null) {
            this.overrideList = this.createOverrides();
        }
        return this.overrideList;
    }

    protected abstract K getInventoryKey(ItemStack var1);

    protected abstract K getWorldKey(IBlockState var1);

    protected abstract void bakeBlock(B var1, K var2, IModelBaker var3, boolean var4);

    private class DefaultItemOverrideList
    extends ItemOverrideList {
        public DefaultItemOverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            if (world == null) {
                world = Proxies.common.getRenderWorld();
            }
            return ModelBlockDefault.this.getModel(stack, world);
        }
    }
}

