/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.DamageSourceForestry;
import forestry.core.utils.VectUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class AlleleEffectRadioactive
extends AlleleEffectThrottled {
    private static final DamageSource damageSourceBeeRadioactive = new DamageSourceForestry("bee.radioactive");

    public AlleleEffectRadioactive() {
        super("radioactive", true, 40, false, true);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        this.harmEntities(genome, housing);
        return AlleleEffectRadioactive.destroyEnvironment(genome, storedData, housing);
    }

    private void harmEntities(IBeeGenome genome, IBeeHousing housing) {
        List<EntityLivingBase> entities = AlleleEffectRadioactive.getEntitiesInRange(genome, housing, EntityLivingBase.class);
        for (EntityLivingBase entity : entities) {
            int damage = 8;
            int count = BeeManager.armorApiaristHelper.wearsItems(entity, this.getUID(), true);
            if ((damage -= count * 2) <= 0) continue;
            entity.func_70097_a(damageSourceBeeRadioactive, (float)damage);
        }
    }

    private static IEffectData destroyEnvironment(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        Random rand = world.field_73012_v;
        BlockPos area = VectUtil.scale(genome.getTerritory(), 2.0f);
        BlockPos offset = VectUtil.scale((Vec3i)area, -0.5f);
        BlockPos posHousing = housing.getCoordinates();
        for (int i = 0; i < 20; ++i) {
            TileEntity tile;
            IBlockState blockState;
            Block block;
            BlockPos randomPos = VectUtil.getRandomPositionInArea(rand, (Vec3i)area);
            BlockPos posBlock = randomPos.func_177971_a((Vec3i)posHousing);
            if ((posBlock = posBlock.func_177971_a((Vec3i)offset)).func_177956_o() <= 1 || posBlock.func_177956_o() >= world.func_72940_L() || posBlock.func_177958_n() == posHousing.func_177958_n() && posBlock.func_177952_p() == posHousing.func_177952_p() && posBlock.func_177956_o() <= posHousing.func_177956_o() || !world.func_175667_e(posBlock) || world.func_175623_d(posBlock) || (block = (blockState = world.func_180495_p(posBlock)).func_177230_c()) instanceof BlockAlveary || (tile = world.func_175625_s(posBlock)) instanceof IBeeHousing || blockState.func_185887_b(world, posBlock) < 0.0f) continue;
            BlockUtil.setBlockToAirWithSound(world, posBlock, blockState);
            break;
        }
        return storedData;
    }
}

