/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.items;

import forestry.api.genetics.ISpeciesRoot;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.core.gui.GuiHandler;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.storage.gui.ContainerNaturalistBackpack;
import forestry.storage.inventory.ItemInventoryBackpackPaged;
import forestry.storage.items.ItemBackpack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemBackpackNaturalist
extends ItemBackpack {
    private final ISpeciesRoot speciesRoot;

    public ItemBackpackNaturalist(ISpeciesRoot speciesRoot, IBackpackDefinition definition) {
        super(definition, EnumBackpackType.NATURALIST);
        this.speciesRoot = speciesRoot;
    }

    @Override
    protected void openGui(EntityPlayer entityplayer) {
        GuiHandler.openGui(entityplayer, this);
    }

    @Override
    public Object getGui(EntityPlayer player, ItemStack heldItem, int page) {
        ItemInventoryBackpackPaged inventory = new ItemInventoryBackpackPaged(player, 125, heldItem, this);
        ContainerNaturalistBackpack container = new ContainerNaturalistBackpack(player, inventory, page);
        return new GuiNaturalistInventory(this.speciesRoot, player, container, page, 5);
    }

    @Override
    public Object getContainer(EntityPlayer player, ItemStack heldItem, int page) {
        ItemInventoryBackpackPaged inventory = new ItemInventoryBackpackPaged(player, 125, heldItem, this);
        return new ContainerNaturalistBackpack(player, inventory, page);
    }
}

