/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.genetics.Tree;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.utils.NBTUtilForestry;
import java.io.IOException;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileTreeContainer
extends TileEntity
implements IStreamable,
IOwnedTile {
    @Nullable
    private ITree containedTree;
    private final OwnerHandler ownerHandler = new OwnerHandler();

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("ContainedTree")) {
            this.containedTree = new Tree(nbttagcompound.func_74775_l("ContainedTree"));
        }
        this.ownerHandler.readFromNBT(nbttagcompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        if (this.containedTree != null) {
            NBTTagCompound subcompound = new NBTTagCompound();
            this.containedTree.writeToNBT(subcompound);
            nbttagcompound.func_74782_a("ContainedTree", (NBTBase)subcompound);
        }
        this.ownerHandler.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        String speciesUID = "";
        ITree tree = this.getTree();
        if (tree != null) {
            speciesUID = tree.getIdent();
        }
        data.func_180714_a(speciesUID);
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        String speciesUID = data.readString();
        ITree tree = TileTreeContainer.getTree(speciesUID);
        this.setTree(tree);
    }

    private static ITree getTree(String speciesUID) {
        IAllele[] treeTemplate = TreeManager.treeRoot.getTemplate(speciesUID);
        Preconditions.checkArgument((treeTemplate != null ? 1 : 0) != 0, (String)"There is no tree template for speciesUID %s", (Object[])new Object[]{speciesUID});
        return TreeManager.treeRoot.templateAsIndividual(treeTemplate);
    }

    public void setTree(ITree tree) {
        this.containedTree = tree;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Nullable
    public ITree getTree() {
        return this.containedTree;
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    public abstract void onBlockTick(World var1, BlockPos var2, IBlockState var3, Random var4);

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !Block.func_149680_a((Block)oldState.func_177230_c(), (Block)newSate.func_177230_c());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound nbt = pkt.func_148857_g();
        this.handleUpdateTag(nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        return NBTUtilForestry.writeStreamableToNbt(this, tag);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        NBTUtilForestry.readStreamableFromNbt(this, tag);
    }
}

