/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.recipes.IVariableFermentable;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.items.IColoredItem;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.Translator;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGermlingGE
extends ItemGE
implements IVariableFermentable,
IColoredItem {
    private final EnumGermlingType type;

    public ItemGermlingGE(EnumGermlingType type) {
        super(Tabs.tabArboriculture);
        this.type = type;
    }

    @Override
    @Nullable
    public ITree getIndividual(ItemStack itemstack) {
        return TreeManager.treeRoot.getMember(itemstack);
    }

    @Override
    protected IAlleleTreeSpecies getSpecies(ItemStack itemStack) {
        return TreeGenome.getSpecies(itemStack);
    }

    public String func_77653_i(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            return "Unknown";
        }
        IAlleleTreeSpecies species = this.getSpecies(itemstack);
        String customTreeKey = "for.trees.custom." + this.type.getName() + "." + species.getUnlocalizedName().replace("trees.species.", "");
        if (Translator.canTranslateToLocal(customTreeKey)) {
            return Translator.translateToLocal(customTreeKey);
        }
        String typeString = Translator.translateToLocal("for.trees.grammar." + this.type.getName() + ".type");
        return Translator.translateToLocal("for.trees.grammar." + this.type.getName()).replaceAll("%SPECIES", species.getName()).replaceAll("%TYPE", typeString);
    }

    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        this.addCreativeItems(subItems, true);
    }

    public void addCreativeItems(NonNullList<ItemStack> subItems, boolean hideSecrets) {
        for (IIndividual iIndividual : TreeManager.treeRoot.getIndividualTemplates()) {
            if (hideSecrets && iIndividual.isSecret() && !Config.isDebug) continue;
            subItems.add((Object)TreeManager.treeRoot.getMemberStack(iIndividual, this.type));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(ItemStack itemstack, int renderPass) {
        return TreeGenome.getSpecies(itemstack).getGermlingColour(this.type, renderPass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, new GermlingMeshDefinition());
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleTreeSpecies)) continue;
            ((IAlleleTreeSpecies)allele).registerModels(item, manager, this.type);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = raytraceresult.func_178782_a();
            ITree tree = TreeManager.treeRoot.getMember(itemStack);
            if (tree != null) {
                if (this.type == EnumGermlingType.SAPLING) {
                    return ItemGermlingGE.onItemRightClickSapling(itemStack, worldIn, playerIn, pos, tree);
                }
                if (this.type == EnumGermlingType.POLLEN) {
                    return ItemGermlingGE.onItemRightClickPollen(itemStack, worldIn, playerIn, pos, tree);
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    private static ActionResult<ItemStack> onItemRightClickPollen(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, BlockPos pos, ITree tree) {
        ICheckPollinatable checkPollinatable = GeneticsUtil.getCheckPollinatable(worldIn, pos);
        if (checkPollinatable == null || !checkPollinatable.canMateWith(tree)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        IPollinatable pollinatable = GeneticsUtil.getOrCreatePollinatable(playerIn.func_146103_bH(), worldIn, pos);
        if (pollinatable == null || !pollinatable.canMateWith(tree)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        pollinatable.mateWith(tree);
        IBlockState blockState = worldIn.func_180495_p(pos);
        PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, blockState);
        Proxies.net.sendNetworkPacket(packet, pos, worldIn);
        if (!playerIn.field_71075_bZ.field_75098_d) {
            itemStackIn.func_190918_g(1);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    private static ActionResult<ItemStack> onItemRightClickSapling(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, BlockPos pos, ITree tree) {
        IBlockState hitBlock = worldIn.func_180495_p(pos);
        if (!hitBlock.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
            }
            pos = pos.func_177984_a();
        }
        if (tree.canStay((IBlockAccess)worldIn, pos) && TreeManager.treeRoot.plantSapling(worldIn, tree, playerIn.func_146103_bH(), pos)) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemStackIn.func_190918_g(1);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    @Override
    public float getFermentationModifier(ItemStack itemstack) {
        ITree tree = TreeManager.treeRoot.getMember(itemstack = GeneticsUtil.convertToGeneticEquivalent(itemstack));
        if (tree == null) {
            return 1.0f;
        }
        return tree.getGenome().getSappiness() * 10.0f;
    }

    @SideOnly(value=Side.CLIENT)
    private class GermlingMeshDefinition
    implements ItemMeshDefinition {
        private GermlingMeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            IAlleleTreeSpecies treeSpecies = ItemGermlingGE.this.getSpecies(stack);
            return treeSpecies.getGermlingModel(ItemGermlingGE.this.type);
        }
    }
}

