/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.network.packets;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IActivatable;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class PacketActiveUpdate
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final boolean active;

    public PacketActiveUpdate(IActivatable tile) {
        this.pos = tile.getCoordinates();
        this.active = tile.isActive();
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.TILE_FORESTRY_ACTIVE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        data.writeBoolean(this.active);
    }

    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) {
            IMultiblockComponent component;
            BlockPos pos = data.func_179259_c();
            boolean active = data.readBoolean();
            TileEntity tile = Proxies.common.getRenderWorld().func_175625_s(pos);
            if (tile instanceof IActivatable) {
                ((IActivatable)tile).setActive(active);
            } else if (tile instanceof IMultiblockComponent && (component = (IMultiblockComponent)tile).getMultiblockLogic().isConnected() && component.getMultiblockLogic().getController() instanceof IActivatable) {
                ((IActivatable)((Object)component.getMultiblockLogic().getController())).setActive(active);
            }
        }
    }
}

