/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MigrationHelper {
    private static Map<String, String> blockRemappings = new HashMap<String, String>();
    private static Map<String, String> itemRemappings = new HashMap<String, String>();
    private static Set<String> ignoredMappings = new HashSet<String>();
    public static Pattern underscores;

    public static void addBlockName(String blockName) {
        MigrationHelper.add(blockName, blockRemappings);
    }

    public static void addItemName(String itemName) {
        MigrationHelper.add(itemName, itemRemappings);
    }

    private static void add(String name, Map<String, String> remappings) {
        String nameWithoutUnderscores = underscores.matcher(name).replaceAll("");
        if (!name.equals(nameWithoutUnderscores) && !remappings.containsKey(nameWithoutUnderscores)) {
            remappings.put(nameWithoutUnderscores, name);
        }
    }

    public static void onMissingMappings(FMLMissingMappingsEvent event) {
        block4: for (FMLMissingMappingsEvent.MissingMapping missingMapping : event.get()) {
            ResourceLocation resourceLocation = missingMapping.resourceLocation;
            String resourcePath = resourceLocation.func_110623_a();
            if (ignoredMappings.contains(resourcePath)) {
                missingMapping.ignore();
                continue;
            }
            switch (missingMapping.type) {
                case BLOCK: {
                    if (!blockRemappings.containsKey(resourcePath)) break;
                    ResourceLocation remappedResourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), blockRemappings.get(resourcePath));
                    if (!ForgeRegistries.BLOCKS.containsKey(remappedResourceLocation)) continue block4;
                    Block remappedBlock = (Block)ForgeRegistries.BLOCKS.getValue(remappedResourceLocation);
                    missingMapping.remap(remappedBlock);
                    break;
                }
                case ITEM: {
                    ResourceLocation remappedResourceLocation;
                    if (!itemRemappings.containsKey(resourcePath) || !ForgeRegistries.ITEMS.containsKey(remappedResourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), itemRemappings.get(resourcePath)))) break;
                    Item remappedItem = (Item)ForgeRegistries.ITEMS.getValue(remappedResourceLocation);
                    missingMapping.remap(remappedItem);
                }
            }
        }
    }

    private MigrationHelper() {
    }

    static {
        ignoredMappings.add("greenhouse.sprinkler");
        itemRemappings.put("greenhouse.dryer", "greenhouse.dehumidifier");
        blockRemappings.put("greenhouse.dryer", "greenhouse.dehumidifier");
        itemRemappings.put("pile_dirt", "loam");
        blockRemappings.put("pile_dirt", "loam");
        itemRemappings.put("pile_wood", "wood_pile");
        blockRemappings.put("pile_wood", "wood_pile");
        blockRemappings.put("pile_ash", "charcoal");
        underscores = Pattern.compile("_");
    }
}

