/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import forestry.arboriculture.blocks.PropertyTreeType;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.core.blocks.IColoredBlock;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockDecorativeLeaves
extends Block
implements IItemModelRegister,
IColoredBlock,
IShearable {
    private static final int VARIANTS_PER_BLOCK = 16;
    private final int blockNumber;

    public static List<BlockDecorativeLeaves> create() {
        ArrayList<BlockDecorativeLeaves> blocks = new ArrayList<BlockDecorativeLeaves>();
        int blockCount = PropertyTreeType.getBlockCount(16);
        for (int blockNumber = 0; blockNumber < blockCount; ++blockNumber) {
            final PropertyTreeType variant = PropertyTreeType.create("variant", blockNumber, 16);
            BlockDecorativeLeaves block = new BlockDecorativeLeaves(blockNumber){

                @Override
                public PropertyTreeType getVariant() {
                    return variant;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    public BlockDecorativeLeaves(int blockNumber) {
        super(Material.field_151584_j);
        this.blockNumber = blockNumber;
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public abstract PropertyTreeType getVariant();

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getVariant()});
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            int meta = this.func_176201_c(state);
            ItemStack itemStack = new ItemStack(itemIn, 1, meta);
            list.add((Object)itemStack);
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        TreeDefinition treeDefinition = (TreeDefinition)((Object)blockState.func_177229_b((IProperty)this.getVariant()));
        if (TreeDefinition.Willow.equals(treeDefinition)) {
            return null;
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.field_70159_w *= 0.4;
        entityIn.field_70179_y *= 0.4;
    }

    public boolean func_149662_c(IBlockState state) {
        return !Proxies.render.fancyGraphicsEnabled();
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Proxies.render.fancyGraphicsEnabled() || blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this) && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (IBlockState state : this.field_176227_L.func_177619_a()) {
            int meta = this.func_176201_c(state);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("forestry:leaves.decorative." + this.blockNumber, "inventory"));
        }
    }

    public IBlockState func_176203_a(int meta) {
        TreeDefinition type = this.getTreeType(meta);
        return this.func_176223_P().func_177226_a((IProperty)this.getVariant(), (Comparable)((Object)type));
    }

    public TreeDefinition getTreeType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = meta % variantCount + this.blockNumber * 16;
        return TreeDefinition.byMetadata(variantMeta);
    }

    public int func_176201_c(IBlockState state) {
        return this.func_180651_a(state);
    }

    public int func_180651_a(IBlockState state) {
        return ((TreeDefinition)((Object)state.func_177229_b((IProperty)this.getVariant()))).getMetadata() - this.blockNumber * 16;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        TreeDefinition type = this.getTreeType(meta);
        return this.func_176223_P().func_177226_a((IProperty)this.getVariant(), (Comparable)((Object)type));
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return 20;
        }
        if (face != EnumFacing.UP) {
            return 10;
        }
        return 5;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        return Collections.singletonList(new ItemStack((Block)this, 1, this.func_180651_a(state)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        TreeDefinition treeDefinition = (TreeDefinition)((Object)state.func_177229_b((IProperty)this.getVariant()));
        ITreeGenome genome = treeDefinition.getGenome();
        if (tintIndex == 0) {
            return genome.getPrimary().getLeafSpriteProvider().getColor(false);
        }
        IFruitProvider fruitProvider = genome.getFruitProvider();
        return fruitProvider.getDecorativeColor();
    }
}

