/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.gui;

import java.util.List;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;

public class GuiTextBox extends GuiTextField {
	private static final int enabledColor = 14737632;
	private static final int disabledColor = 7368816;

	private final FontRenderer fontRendererObj;
	private final int startX, startY, width, height;

	private int lineScroll = 0;
	private int maxLines = 0;

	public GuiTextBox(int ID, FontRenderer fontRendererObj, int startX, int startY, int width, int height) {
		super(ID, fontRendererObj, startX, startY, width, height);
		this.fontRendererObj = fontRendererObj;
		this.startX = startX;
		this.startY = startY;
		this.width = width;
		this.height = height;
	}

	private int getLineScrollOffset() {
		return 0;
	}

	public void advanceLine() {
		if (lineScroll < maxLines - 1) {
			lineScroll++;
		}
	}

	public void regressLine() {
		if (lineScroll > 0) {
			lineScroll--;
		}
	}

	public boolean moreLinesAllowed() {
		return fontRendererObj.func_78271_c(getCursoredText(), width).size() * fontRendererObj.field_78288_b < height;
	}

	private String getCursoredText() {
		if (!func_146206_l()) {
			return func_146179_b();
		}

		int cursorPos = func_146198_h() - getLineScrollOffset();
		String text = func_146179_b();
		if (cursorPos < 0) {
			return text;
		}
		if (cursorPos >= text.length()) {
			return text + "_";
		}
		return text.substring(0, cursorPos) + "_" + text.substring(cursorPos);
	}

	private void drawScrolledSplitString(String text, int startX, int startY, int width, int textColour) {
		List<String> lines = fontRendererObj.func_78271_c(text, width);
		maxLines = lines.size();

		int count = 0;
		int lineY = startY;

		for (String line : lines) {
			if (count < lineScroll) {
				count++;
				continue;
			} else if (lineY + fontRendererObj.field_78288_b - startY > height) {
				break;
			}

			fontRendererObj.func_78276_b(line, startX, lineY, textColour);
			lineY += fontRendererObj.field_78288_b;

			count++;
		}

	}

	@Override
	public void func_146194_f() {
		if (!func_146176_q()) {
			return;
		}

		if (func_146181_i()) {
			func_73734_a(startX - 1, startY - 1, startX + this.width + 1, startY + this.height + 1, -6250336);
			func_73734_a(startX, startY, startX + this.width, startY + this.height, -16777216);
		}

		int textColour = func_146206_l() ? enabledColor : disabledColor;

		drawScrolledSplitString(getCursoredText(), startX + 2, startY + 2, width - 4, textColour);
	}

}
