/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import com.google.common.collect.ImmutableMap;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IHiveTile;
import forestry.apiculture.entities.ParticleBeeExplore;
import forestry.apiculture.entities.ParticleBeeRoundTrip;
import forestry.apiculture.entities.ParticleBeeTargetEntity;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.apiculture.render.TextureHabitatLocator;
import forestry.core.config.Config;
import forestry.core.entities.ParticleHoneydust;
import forestry.core.entities.ParticleIgnition;
import forestry.core.entities.ParticleSmoke;
import forestry.core.entities.ParticleSnow;
import forestry.core.fluids.Fluids;
import forestry.core.models.BlockModelEntry;
import forestry.core.models.ModelEntry;
import forestry.core.models.ModelManager;
import forestry.core.proxy.Proxies;
import forestry.core.proxy.ProxyRender;
import forestry.core.render.RenderAnalyzer;
import forestry.core.render.RenderEscritoire;
import forestry.core.render.RenderMachine;
import forestry.core.render.RenderMill;
import forestry.core.render.RenderNaturalistChest;
import forestry.core.render.TextureManager;
import forestry.core.render.TextureMapForestry;
import forestry.core.tiles.TileAnalyzer;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileEscritoire;
import forestry.core.tiles.TileMill;
import forestry.core.tiles.TileNaturalistChest;
import forestry.core.utils.VectUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;

public class ProxyRenderClient
extends ProxyRender {
    @Override
    public boolean fancyGraphicsEnabled() {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    @Override
    public boolean hasRendering() {
        return true;
    }

    @Override
    public void initRendering() {
        TextureManager textureManager = TextureManager.getInstance();
        TextureMapForestry textureMap = textureManager.getTextureMap();
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71446_o.func_110580_a(TextureManager.getInstance().getGuiTextureMap(), (ITickableTextureObject)textureMap);
    }

    @Override
    public TileEntitySpecialRenderer<TileBase> getRenderDefaultMachine(String gfxBase) {
        return new RenderMachine(gfxBase);
    }

    @Override
    public TileEntitySpecialRenderer<TileMill> getRenderMill(String gfxBase) {
        return new RenderMill(gfxBase);
    }

    @Override
    public TileEntitySpecialRenderer<TileMill> getRenderMill(String gfxBase, byte charges) {
        return new RenderMill(gfxBase, charges);
    }

    @Override
    public TileEntitySpecialRenderer<TileEscritoire> getRenderEscritoire() {
        return new RenderEscritoire();
    }

    @Override
    public TileEntitySpecialRenderer<TileAnalyzer> getRendererAnalyzer() {
        return new RenderAnalyzer("textures/blocks/analyzer_");
    }

    @Override
    public TileEntitySpecialRenderer<TileNaturalistChest> getRenderChest(String textureName) {
        return new RenderNaturalistChest(textureName);
    }

    @Override
    public void setHabitatLocatorTexture(@Nullable Entity player, @Nullable BlockPos pos) {
        TextureHabitatLocator.getInstance().setTargetCoordinates(pos);
    }

    @Override
    public IResourceManager getSelectedTexturePack() {
        return Minecraft.func_71410_x().func_110442_L();
    }

    @Override
    public void bindTexture(ResourceLocation location) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
    }

    @Override
    public void registerBlockModel(BlockModelEntry index) {
        ModelManager.getInstance().registerCustomBlockModel(index);
        if (index.addStateMapper) {
            BlockModeStateMapper ignoreState = new BlockModeStateMapper(index);
            this.registerStateMapper(index.block, (IStateMapper)ignoreState);
        }
    }

    @Override
    public void registerModel(ModelEntry index) {
        ModelManager.getInstance().registerCustomModel(index);
    }

    @Override
    public void registerFluidStateMapper(Block block, Fluids forestryFluid) {
        ModelResourceLocation fluidLocation = new ModelResourceLocation("forestry:blockforestryfluid", forestryFluid.getTag());
        FluidStateMapper ignoreState = new FluidStateMapper(fluidLocation);
        this.registerStateMapper(block, (IStateMapper)ignoreState);
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)block), (ItemMeshDefinition)new FluidItemMeshDefinition(fluidLocation));
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)block), (ResourceLocation[])new ResourceLocation[]{fluidLocation});
    }

    @Override
    public void registerStateMapper(Block block, IStateMapper mapper) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    @Override
    public void registerModels() {
        ModelManager.getInstance().registerModels();
    }

    @Override
    public void registerItemAndBlockColors() {
        ModelManager.getInstance().registerItemAndBlockColors();
    }

    @Override
    public IAnimationStateMachine loadAnimationState(ResourceLocation location, ImmutableMap<String, ITimeValue> parameters) {
        return ModelLoaderRegistry.loadASM((ResourceLocation)location, parameters);
    }

    private static boolean shouldSpawnParticle(World world) {
        if (!Config.enableParticleFX) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        int particleSetting = mc.field_71474_y.field_74362_aa;
        if (particleSetting == 2) {
            return world.field_73012_v.nextInt(10) == 0;
        }
        if (particleSetting == 1) {
            return world.field_73012_v.nextInt(3) != 0;
        }
        return true;
    }

    @Override
    public void addBeeHiveFX(IBeeHousing housing, IBeeGenome genome, List<BlockPos> flowerPositions) {
        World world = housing.getWorldObj();
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        Vec3d particleStart = housing.getBeeFXCoordinates();
        BlockPos playerPosition = Proxies.common.getPlayer().func_180425_c();
        double playerDistanceSq = playerPosition.func_177957_d(particleStart.field_72450_a, particleStart.field_72448_b, particleStart.field_72449_c);
        if ((double)world.field_73012_v.nextInt(1024) < playerDistanceSq) {
            return;
        }
        int color = genome.getPrimary().getSpriteColour(0);
        if (!flowerPositions.isEmpty()) {
            List<EntityLivingBase> entitiesInRange;
            int randomInt = world.field_73012_v.nextInt(100);
            if (housing instanceof IHiveTile && (((IHiveTile)((Object)housing)).isAngry() || randomInt >= 85) && !(entitiesInRange = AlleleEffect.getEntitiesInRange(genome, housing, EntityLivingBase.class)).isEmpty()) {
                EntityLivingBase entity = entitiesInRange.get(world.field_73012_v.nextInt(entitiesInRange.size()));
                ParticleBeeTargetEntity particle = new ParticleBeeTargetEntity(world, particleStart, (Entity)entity, color);
                effectRenderer.func_78873_a((Particle)particle);
                return;
            }
            if (randomInt < 75) {
                BlockPos destination = flowerPositions.get(world.field_73012_v.nextInt(flowerPositions.size()));
                ParticleBeeRoundTrip particle = new ParticleBeeRoundTrip(world, particleStart, destination, color);
                effectRenderer.func_78873_a((Particle)particle);
            } else {
                Vec3i area = AlleleEffect.getModifiedArea(genome, housing);
                BlockPos offset = housing.getCoordinates().func_177982_a(-area.func_177958_n() / 2, -area.func_177956_o() / 4, -area.func_177952_p() / 2);
                BlockPos destination = VectUtil.getRandomPositionInArea(world.field_73012_v, area).func_177971_a((Vec3i)offset);
                ParticleBeeExplore particle = new ParticleBeeExplore(world, particleStart, destination, color);
                effectRenderer.func_78873_a((Particle)particle);
            }
        }
    }

    @Override
    public void addEntityHoneyDustFX(World world, double x, double y, double z) {
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        effectRenderer.func_78873_a((Particle)new ParticleHoneydust(world, x, y, z, 0.0f, 0.0f, 0.0f));
    }

    @Override
    public void addEntityExplodeFX(World world, double x, double y, double z) {
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        Particle Particle2 = effectRenderer.func_178927_a(EnumParticleTypes.EXPLOSION_NORMAL.func_179348_c(), x, y, z, 0.0, 0.0, 0.0, new int[0]);
        effectRenderer.func_78873_a(Particle2);
    }

    @Override
    public void addEntitySnowFX(World world, double x, double y, double z) {
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        effectRenderer.func_78873_a((Particle)new ParticleSnow(world, x + world.field_73012_v.nextGaussian(), y, z + world.field_73012_v.nextGaussian()));
    }

    @Override
    public void addEntityIgnitionFX(World world, double x, double y, double z) {
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        effectRenderer.func_78873_a((Particle)new ParticleIgnition(world, x, y, z));
    }

    @Override
    public void addEntitySmokeFX(World world, double x, double y, double z) {
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        effectRenderer.func_78873_a((Particle)new ParticleSmoke(world, x, y, z));
    }

    @Override
    public void addEntityPotionFX(World world, double x, double y, double z, int color) {
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        Particle particle = effectRenderer.func_178927_a(EnumParticleTypes.SPELL.func_179348_c(), x, y, z, 0.0, 0.0, 0.0, new int[0]);
        if (particle != null) {
            particle.func_70538_b(red, green, blue);
            effectRenderer.func_78873_a(particle);
        }
    }

    private static class FluidItemMeshDefinition
    implements ItemMeshDefinition {
        private final ModelResourceLocation fluidLocation;

        public FluidItemMeshDefinition(ModelResourceLocation fluidLocation) {
            this.fluidLocation = fluidLocation;
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.fluidLocation;
        }
    }

    private static class FluidStateMapper
    extends StateMapperBase {
        private final ModelResourceLocation fluidLocation;

        public FluidStateMapper(ModelResourceLocation fluidLocation) {
            this.fluidLocation = fluidLocation;
        }

        protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
            return this.fluidLocation;
        }
    }

    private static class BlockModeStateMapper
    extends StateMapperBase {
        private final BlockModelEntry index;

        public BlockModeStateMapper(BlockModelEntry index) {
            this.index = index;
        }

        protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
            return this.index.blockModelLocation;
        }
    }
}

