/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.fluids.FakeTankUpdateHandler;
import forestry.core.fluids.ITankUpdateHandler;
import forestry.core.fluids.TankManager;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.utils.Translator;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.item.EnumRarity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class StandardTank
extends FluidTank
implements IStreamable {
    private static final int DEFAULT_COLOR = 0xFFFFFF;
    private ITankUpdateHandler tankUpdateHandler = FakeTankUpdateHandler.instance;
    private int tankIndex;
    protected final ToolTip toolTip = new ToolTip(){

        @Override
        public void refresh() {
            StandardTank.this.refreshTooltip();
        }
    };

    public StandardTank(int capacity, boolean canFill, boolean canDrain) {
        super(capacity);
        this.setCanFill(canFill);
        this.setCanDrain(canDrain);
    }

    public StandardTank(int capacity) {
        super(capacity);
    }

    public void setTankIndex(int index) {
        this.tankIndex = index;
    }

    public void setTankUpdateHandler(TankManager tankUpdateHandler) {
        this.tankUpdateHandler = tankUpdateHandler;
    }

    public int getTankIndex() {
        return this.tankIndex;
    }

    public int getColor() {
        Fluid f = this.getFluidType();
        if (f == null) {
            return 0xFFFFFF;
        }
        return f.getColor(this.getFluid());
    }

    public boolean isEmpty() {
        return this.getFluid() == null || this.getFluid().amount <= 0;
    }

    public boolean isFull() {
        return this.getFluid() != null && this.getFluid().amount == this.getCapacity();
    }

    public int getRemainingSpace() {
        return this.capacity - this.getFluidAmount();
    }

    @Nullable
    public Fluid getFluidType() {
        return this.getFluid() != null ? this.getFluid().getFluid() : null;
    }

    public int fillInternal(FluidStack resource, boolean doFill) {
        int filled = super.fillInternal(resource, doFill);
        if (doFill && filled > 0) {
            this.tankUpdateHandler.updateTankLevels(this);
        }
        return filled;
    }

    @Nullable
    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        FluidStack drained = super.drainInternal(maxDrain, doDrain);
        if (doDrain && drained != null && drained.amount > 0) {
            this.tankUpdateHandler.updateTankLevels(this);
        }
        return drained;
    }

    public String toString() {
        return String.format("Tank: %s, %d/%d", this.fluid != null && this.fluid.getFluid() != null ? this.fluid.getFluid().getName() : "Empty", this.getFluidAmount(), this.getCapacity());
    }

    public ToolTip getToolTip() {
        return this.toolTip;
    }

    protected boolean hasFluid() {
        FluidStack fluid = this.getFluid();
        return fluid != null && fluid.amount > 0 && fluid.getFluid() != null;
    }

    protected void refreshTooltip() {
        this.toolTip.clear();
        int amount = 0;
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            Fluid fluidType = fluidStack.getFluid();
            EnumRarity rarity = fluidType.getRarity();
            if (rarity == null) {
                rarity = EnumRarity.COMMON;
            }
            this.toolTip.add(fluidType.getLocalizedName(this.getFluid()), rarity.field_77937_e);
            amount = this.getFluid().amount;
        }
        String liquidAmount = Translator.translateToLocalFormatted("for.gui.tooltip.liquid.amount", amount, this.getCapacity());
        this.toolTip.add(liquidAmount);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeFluidStack(this.fluid);
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        this.fluid = data.readFluidStack();
    }
}

