/*
 * Decompiled with CFR 0.152.
 */
package forestry.food;

import forestry.api.food.IBeverageEffect;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class InfuserMixture {
    private final int meta;
    private final NonNullList<ItemStack> ingredients;
    private final IBeverageEffect effect;

    public InfuserMixture(int meta, NonNullList<ItemStack> ingredients, IBeverageEffect effect) {
        this.meta = meta;
        this.ingredients = ingredients;
        this.effect = effect;
    }

    public NonNullList<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public boolean isIngredient(ItemStack itemstack) {
        for (ItemStack ingredient : this.ingredients) {
            if (ingredient.func_77952_i() < 0 && ingredient.func_77973_b() == itemstack.func_77973_b()) {
                return true;
            }
            if (ingredient.func_77952_i() < 0 || !ingredient.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(NonNullList<ItemStack> res) {
        if (res.isEmpty()) {
            return false;
        }
        boolean matchedAll = true;
        for (ItemStack stack : this.ingredients) {
            boolean matched = false;
            for (ItemStack matchStack : res) {
                if (matchStack == null) continue;
                if (stack.func_77952_i() < 0 && stack.func_77973_b() == matchStack.func_77973_b()) {
                    if (stack.func_190916_E() > matchStack.func_190916_E()) continue;
                    matched = true;
                    break;
                }
                if (stack.func_77952_i() < 0 || !stack.func_77969_a(matchStack) || stack.func_190916_E() > matchStack.func_190916_E()) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            matchedAll = false;
        }
        return matchedAll;
    }

    public IBeverageEffect getEffect() {
        return this.effect;
    }

    public int getMeta() {
        return this.meta;
    }

    public int getWeight() {
        return this.ingredients.size();
    }
}

