/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.core.INbtWritable;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.factory.recipes.MemorizedRecipe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class RecipeMemory
implements INbtWritable,
IStreamable {
    private static final int capacity = 9;
    private static final List<Class<? extends Item>> memoryBlacklist = new ArrayList<Class<? extends Item>>();
    private final LinkedList<MemorizedRecipe> memorizedRecipes = new LinkedList();
    private long lastUpdate;

    public RecipeMemory() {
    }

    public RecipeMemory(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("RecipeMemory")) {
            return;
        }
        NBTTagList nbttaglist = nbt.func_150295_c("RecipeMemory", 10);
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound recipeNbt = nbttaglist.func_150305_b(j);
            MemorizedRecipe recipe = new MemorizedRecipe(recipeNbt);
            this.memorizedRecipes.add(recipe);
        }
    }

    private static boolean isValid(@Nullable MemorizedRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack recipeOutput = recipe.getRecipeOutput();
        if (recipeOutput.func_190926_b()) {
            return false;
        }
        Item item = recipeOutput.func_77973_b();
        return !memoryBlacklist.contains(item.getClass());
    }

    public void validate(World world) {
        Iterator iterator = this.memorizedRecipes.iterator();
        while (iterator.hasNext()) {
            MemorizedRecipe recipe = (MemorizedRecipe)iterator.next();
            if (recipe == null) continue;
            recipe.calculateRecipeOutput(world);
            if (RecipeMemory.isValid(recipe)) continue;
            iterator.remove();
        }
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void memorizeRecipe(long worldTime, MemorizedRecipe recipe) {
        MemorizedRecipe memory;
        if (!RecipeMemory.isValid(recipe)) {
            return;
        }
        this.lastUpdate = worldTime;
        recipe.updateLastUse(this.lastUpdate);
        if (recipe.hasRecipeConflict()) {
            recipe.removeRecipeConflicts();
        }
        if ((memory = this.getExistingMemorizedRecipe(recipe.getRecipeOutput())) != null) {
            this.updateExistingRecipe(memory, recipe);
            return;
        }
        if (this.memorizedRecipes.size() < 9) {
            this.memorizedRecipes.add(recipe);
        } else {
            MemorizedRecipe oldest = this.getOldestUnlockedRecipe();
            if (oldest != null) {
                this.memorizedRecipes.remove(oldest);
                this.memorizedRecipes.add(recipe);
            }
        }
    }

    private void updateExistingRecipe(MemorizedRecipe existingRecipe, MemorizedRecipe updatedRecipe) {
        if (existingRecipe.isLocked() != updatedRecipe.isLocked()) {
            updatedRecipe.toggleLock();
        }
        int index = this.memorizedRecipes.indexOf(existingRecipe);
        this.memorizedRecipes.set(index, updatedRecipe);
    }

    @Nullable
    private MemorizedRecipe getOldestUnlockedRecipe() {
        MemorizedRecipe oldest = null;
        for (MemorizedRecipe existing : this.memorizedRecipes) {
            if (oldest != null && oldest.getLastUsed() < existing.getLastUsed() || existing.isLocked()) continue;
            oldest = existing;
        }
        return oldest;
    }

    @Nullable
    public MemorizedRecipe getRecipe(int recipeIndex) {
        if (recipeIndex < 0 || recipeIndex >= this.memorizedRecipes.size()) {
            return null;
        }
        return this.memorizedRecipes.get(recipeIndex);
    }

    public ItemStack getRecipeDisplayOutput(int recipeIndex) {
        MemorizedRecipe recipe = this.getRecipe(recipeIndex);
        if (recipe == null) {
            return ItemStack.field_190927_a;
        }
        return recipe.getRecipeOutput();
    }

    public boolean isLocked(int recipeIndex) {
        MemorizedRecipe recipe = this.getRecipe(recipeIndex);
        return recipe != null && recipe.isLocked();
    }

    public void toggleLock(long worldTime, int recipeIndex) {
        this.lastUpdate = worldTime;
        if (this.memorizedRecipes.size() > recipeIndex) {
            this.memorizedRecipes.get(recipeIndex).toggleLock();
        }
    }

    @Nullable
    private MemorizedRecipe getExistingMemorizedRecipe(ItemStack craftingRecipeOutput) {
        for (MemorizedRecipe memorizedRecipe : this.memorizedRecipes) {
            if (!memorizedRecipe.hasRecipeOutput(craftingRecipeOutput)) continue;
            return memorizedRecipe;
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (MemorizedRecipe recipe : this.memorizedRecipes) {
            if (recipe == null) continue;
            NBTTagCompound recipeNbt = new NBTTagCompound();
            recipe.writeToNBT(recipeNbt);
            nbttaglist.func_74742_a((NBTBase)recipeNbt);
        }
        nbttagcompound.func_74782_a("RecipeMemory", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeStreamables(this.memorizedRecipes);
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        data.readStreamables(this.memorizedRecipes, MemorizedRecipe::new);
    }

    static {
        memoryBlacklist.add(ItemMap.class);
    }
}

