/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import forestry.core.utils.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.VariantList;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelProcessingHelper;
import net.minecraftforge.client.model.MultiModel;
import net.minecraftforge.client.model.MultiModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;

public enum WoodModelLoader implements ICustomModelLoader
{
    INSTANCE;

    public static final Map<ResourceLocation, Exception> loadingExceptions;
    private final Map<ResourceLocation, ModelBlockDefinition> blockDefinitions = Maps.newHashMap();
    public static final List<String> validFiles;
    public boolean isRegistered = false;

    public void func_110549_a(IResourceManager resourceManager) {
    }

    public boolean accepts(ResourceLocation modelLocation) {
        if (!(modelLocation instanceof ModelResourceLocation && modelLocation.func_110624_b().equals("forestry") && modelLocation.func_110623_a().contains("arboriculture"))) {
            return false;
        }
        String path = modelLocation.func_110623_a();
        for (String validFile : validFiles) {
            if (!path.endsWith(validFile)) continue;
            return true;
        }
        return false;
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        ModelResourceLocation variant = (ModelResourceLocation)modelLocation;
        ModelBlockDefinition definition = this.getModelBlockDefinition((ResourceLocation)variant);
        try {
            VariantList variants = definition.func_188004_c(variant.func_177518_c());
            return new WeightedRandomModel((ResourceLocation)variant, variants);
        }
        catch (ModelBlockDefinition.MissingVariantException e) {
            if (definition.func_188002_b()) {
                Log.error("The forestry model loader can't load the model with the location: %s, because it dons't support multipart models.", modelLocation.toString());
            }
            throw e;
        }
    }

    private ModelBlockDefinition getModelBlockDefinition(ResourceLocation location) {
        try {
            ResourceLocation resourcelocation = this.getBlockstateLocation(location);
            return this.blockDefinitions.computeIfAbsent(resourcelocation, k -> this.loadMultipartMBD(location, resourcelocation));
        }
        catch (Exception exception) {
            loadingExceptions.put(location, new Exception("Could not load model definition for variant " + location, exception));
            return new ModelBlockDefinition(new ArrayList());
        }
    }

    private ResourceLocation getBlockstateLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), "blockstates/" + location.func_110623_a() + ".json");
    }

    private ModelBlockDefinition loadMultipartMBD(ResourceLocation location, ResourceLocation fileIn) {
        ArrayList list = Lists.newArrayList();
        try {
            for (IResource iresource : Minecraft.func_71410_x().func_110442_L().func_135056_b(fileIn)) {
                list.add(this.loadModelBlockDefinition(location, iresource));
            }
        }
        catch (IOException ioexception) {
            throw new RuntimeException("Encountered an exception when loading model definition of model " + fileIn, ioexception);
        }
        return new ModelBlockDefinition((List)list);
    }

    private ModelBlockDefinition loadModelBlockDefinition(ResourceLocation location, IResource iresource) {
        ModelBlockDefinition definition;
        InputStream inputstream = null;
        try {
            inputstream = iresource.func_110527_b();
            definition = ModelBlockDefinition.func_178331_a((Reader)new InputStreamReader(inputstream, Charsets.UTF_8));
        }
        catch (Exception exception) {
            throw new RuntimeException("Encountered an exception when loading model definition of '" + location + "' from: '" + iresource.func_177241_a() + "' in resourcepack: '" + iresource.func_177240_d() + "'", exception);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
        return definition;
    }

    static {
        loadingExceptions = Maps.newHashMap();
        validFiles = new ArrayList<String>();
        validFiles.add("door");
        validFiles.add("double_slab");
        validFiles.add("fence");
        validFiles.add("fence_gate");
        validFiles.add("log");
        validFiles.add("planks");
        validFiles.add("slab");
        validFiles.add("stairs");
    }

    private class WeightedRandomModel
    implements IRetexturableModel {
        private final List<Variant> variants;
        private final List<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        private final Set<ResourceLocation> textures = Sets.newHashSet();
        private final List<IModel> models = new ArrayList<IModel>();
        private final IModelState defaultState;

        public WeightedRandomModel(List<ResourceLocation> locations, List<IModel> models, List<Variant> variants, IModelState defaultState) {
            this.locations.addAll(locations);
            this.models.addAll(models);
            this.variants = variants;
            this.defaultState = defaultState;
            for (IModel model : models) {
                this.textures.addAll(model.getTextures());
            }
        }

        public WeightedRandomModel(ResourceLocation parent, VariantList variants) throws Exception {
            this.variants = variants.func_188114_a();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Variant v : this.variants) {
                ResourceLocation loc = v.func_188046_a();
                this.locations.add(loc);
                IModel model = loc.equals((Object)new ModelResourceLocation("builtin/missing", "missing")) ? ModelLoaderRegistry.getMissingModel() : ModelLoaderRegistry.getModel((ResourceLocation)loc);
                model = v.process(model);
                for (ResourceLocation location : model.getDependencies()) {
                    ModelLoaderRegistry.getModelOrMissing((ResourceLocation)location);
                }
                this.textures.addAll(model.getTextures());
                this.models.add(model);
                builder.add((Object)Pair.of((Object)model, (Object)v.getState()));
            }
            if (this.models.size() == 0) {
                IModel missing = ModelLoaderRegistry.getMissingModel();
                this.models.add(missing);
                builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
            }
            this.defaultState = new MultiModelState(builder.build());
        }

        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.copyOf(this.locations);
        }

        public Collection<ResourceLocation> getTextures() {
            return ImmutableSet.copyOf(this.textures);
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            if (this.variants.size() == 1) {
                IModel model = this.models.get(0);
                return model.bake(MultiModelState.getPartState((IModelState)state, (IModel)model, (int)0), format, bakedTextureGetter);
            }
            WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder();
            for (int i = 0; i < this.variants.size(); ++i) {
                IModel model = this.models.get(i);
                builder.func_177677_a(model.bake(MultiModelState.getPartState((IModelState)state, (IModel)model, (int)i), format, bakedTextureGetter), this.variants.get(i).func_188047_d());
            }
            return builder.func_177676_a();
        }

        public IModelState getDefaultState() {
            return this.defaultState;
        }

        public IModel retexture(ImmutableMap<String, String> textures) {
            ArrayList<IModel> models = new ArrayList<IModel>();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Variant v : this.variants) {
                IModel model;
                ResourceLocation loc = v.func_188046_a();
                this.locations.add(loc);
                if (loc.equals((Object)new ModelResourceLocation("builtin/missing", "missing"))) {
                    model = ModelLoaderRegistry.getMissingModel();
                } else {
                    try {
                        model = ModelLoaderRegistry.getModel((ResourceLocation)loc);
                    }
                    catch (Exception e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
                model = v.process(model);
                for (ResourceLocation location : model.getDependencies()) {
                    ModelLoaderRegistry.getModelOrMissing((ResourceLocation)location);
                }
                if (model instanceof MultiModel) {
                    IModel base = (IModel)ObfuscationReflectionHelper.getPrivateValue(MultiModel.class, (Object)((MultiModel)model), (int)1);
                    Map parts = (Map)ObfuscationReflectionHelper.getPrivateValue(MultiModel.class, (Object)((MultiModel)model), (int)3);
                    ImmutableMap.Builder partBuilder = new ImmutableMap.Builder();
                    IModel retexturedModel = ModelProcessingHelper.retexture((IModel)base, textures);
                    for (Map.Entry part : parts.entrySet()) {
                        partBuilder.put(part.getKey(), (Object)Pair.of((Object)ModelProcessingHelper.retexture((IModel)((IModel)((Pair)part.getValue()).getLeft()), textures), (Object)((Pair)part.getValue()).getRight()));
                    }
                    ObfuscationReflectionHelper.setPrivateValue(MultiModel.class, (Object)((MultiModel)model), (Object)retexturedModel, (int)1);
                    ObfuscationReflectionHelper.setPrivateValue(MultiModel.class, (Object)((MultiModel)model), (Object)partBuilder.build(), (int)3);
                }
                model = ModelProcessingHelper.retexture((IModel)model, textures);
                models.add(model);
                builder.add((Object)Pair.of((Object)model, (Object)v.getState()));
            }
            if (models.size() == 0) {
                IModel missing = ModelLoaderRegistry.getMissingModel();
                models.add(missing);
                builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
            }
            return new WeightedRandomModel(this.locations, models, this.variants, (IModelState)new MultiModelState(builder.build()));
        }
    }
}

