/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.genetics.alleles;

import java.util.List;
import java.util.Random;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.DamageSourceForestry;
import forestry.core.utils.VectUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class AlleleEffectRadioactive extends AlleleEffectThrottled {

	private static final DamageSource damageSourceBeeRadioactive = new DamageSourceForestry("bee.radioactive");

	public AlleleEffectRadioactive() {
		super("radioactive", true, 40, false, true);
	}

	@Override
	public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
		harmEntities(genome, housing);

		return destroyEnvironment(genome, storedData, housing);
	}

	private void harmEntities(IBeeGenome genome, IBeeHousing housing) {
		List<EntityLivingBase> entities = getEntitiesInRange(genome, housing, EntityLivingBase.class);
		for (EntityLivingBase entity : entities) {
			int damage = 8;

			// Entities are not attacked if they wear a full set of apiarist's armor.
			int count = BeeManager.armorApiaristHelper.wearsItems(entity, getUID(), true);
			damage -= count * 2;
			if (damage <= 0) {
				continue;
			}

			entity.func_70097_a(damageSourceBeeRadioactive, damage);
		}
	}

	private static IEffectData destroyEnvironment(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
		World world = housing.getWorldObj();
		Random rand = world.field_73012_v;

		Vec3i area = VectUtil.scale(genome.getTerritory(), 2);
		Vec3i offset = VectUtil.scale(area, -1 / 2.0f);
		BlockPos posHousing = housing.getCoordinates();

		for (int i = 0; i < 20; i++) {
			BlockPos randomPos = VectUtil.getRandomPositionInArea(rand, area);
			BlockPos posBlock = randomPos.func_177971_a(posHousing);
			posBlock = posBlock.func_177971_a(offset);

			if (posBlock.func_177956_o() <= 1 || posBlock.func_177956_o() >= world.func_72940_L()) {
				continue;
			}

			// Don't destroy ourselves or blocks below us.
			if (posBlock.func_177958_n() == posHousing.func_177958_n() && posBlock.func_177952_p() == posHousing.func_177952_p() && posBlock.func_177956_o() <= posHousing.func_177956_o()) {
				continue;
			}

			if (!world.func_175667_e(posBlock) || world.func_175623_d(posBlock)) {
				continue;
			}

			IBlockState blockState = world.func_180495_p(posBlock);
			Block block = blockState.func_177230_c();

			if (block instanceof BlockAlveary) {
				continue;
			}

			TileEntity tile = world.func_175625_s(posBlock);
			if (tile instanceof IBeeHousing) {
				continue;
			}

			if (blockState.func_185887_b(world, posBlock) < 0) {
				continue;
			}

			BlockUtil.setBlockToAirWithSound(world, posBlock, blockState);
			break;
		}

		return storedData;
	}
}
