/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.greenhouse.GreenhouseEvents;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.api.multiblock.MultiblockTileEntityBase;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.CamouflageSelectionType;
import forestry.core.network.packets.PacketCamouflageSelectServer;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.PlayerUtil;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileGreenhouseHatch
extends MultiblockTileEntityBase<MultiblockLogicGreenhouse>
implements IGreenhouseComponent,
IStreamableGui,
IErrorLogicSource,
IOwnedTile,
ICamouflageHandler,
ICamouflagedTile {
    @Nullable
    private EnumFacing outwards = null;
    private ItemStack camouflageBlock = ItemStack.field_190927_a;
    @Nullable
    private GameProfile owner;

    public TileGreenhouseHatch() {
        super(new MultiblockLogicGreenhouse());
    }

    @Nullable
    public EnumFacing getOutwardsDir() {
        return this.outwards;
    }

    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), false);
        this.func_70296_d();
        this.recalculateOutwardsDirection(minCoord, maxCoord);
    }

    @Override
    public void onMachineBroken() {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), false);
        this.func_70296_d();
        this.outwards = null;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("CamouflageBlock")) {
            this.camouflageBlock = new ItemStack(data.func_74775_l("CamouflageBlock"));
        }
        if (data.func_74764_b("owner")) {
            NBTTagCompound ownerNbt = data.func_74775_l("owner");
            this.owner = PlayerUtil.readGameProfileFromNBT(ownerNbt);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        if (!this.camouflageBlock.func_190926_b()) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.camouflageBlock.func_77955_b(nbtTag);
            data.func_74782_a("CamouflageBlock", (NBTBase)nbtTag);
        }
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            PlayerUtil.writeGameProfile(nbt, this.owner);
            data.func_74782_a("owner", (NBTBase)nbt);
        }
        return data;
    }

    @Override
    @Nullable
    public final GameProfile getOwner() {
        return this.owner;
    }

    public final void setOwner(GameProfile owner) {
        this.owner = owner;
    }

    @Override
    public boolean setCamouflageBlock(String type, ItemStack camouflageBlock, boolean sendClientUpdate) {
        if (!ItemStackUtil.isIdenticalItem(camouflageBlock, this.camouflageBlock)) {
            this.camouflageBlock = camouflageBlock;
            if (sendClientUpdate && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
                Proxies.net.sendToServer(new PacketCamouflageSelectServer(this, type, CamouflageSelectionType.TILE));
            }
            MinecraftForge.EVENT_BUS.post((Event)new GreenhouseEvents.CamouflageChangeEvent(((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController(), this, this, type));
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getCamouflageBlock(String type) {
        return this.camouflageBlock;
    }

    @Override
    public ItemStack getDefaultCamouflageBlock(String type) {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean canHandleType(String type) {
        return type.equals(this.getCamouflageType());
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().writeGuiData(data);
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().readGuiData(data);
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        if (!this.camouflageBlock.func_190926_b()) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.camouflageBlock.func_77955_b(nbtTag);
            packetData.func_74782_a("CamouflageBlock", (NBTBase)nbtTag);
        }
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        if (packetData.func_74764_b("CamouflageBlock")) {
            this.setCamouflageBlock(this.getCamouflageType(), new ItemStack(packetData.func_74775_l("CamouflageBlock")), true);
        }
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getErrorLogic();
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getOwnerHandler();
    }

    @Override
    public String getCamouflageType() {
        if (this.func_145838_q() instanceof BlockGreenhouse && ((BlockGreenhouse)this.func_145838_q()).getGreenhouseType() == BlockGreenhouseType.GLASS) {
            return "glass";
        }
        return "block";
    }

    @Nullable
    private TileEntity getOutwardsTile() {
        if (this.outwards == null || this.field_145850_b == null || this.field_174879_c == null) {
            return null;
        }
        return this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.outwards));
    }

    public void recalculateOutwardsDirection(BlockPos minCoord, BlockPos maxCoord) {
        this.outwards = null;
        int facesMatching = 0;
        if (maxCoord.func_177958_n() == this.func_174877_v().func_177958_n() || minCoord.func_177958_n() == this.func_174877_v().func_177958_n()) {
            ++facesMatching;
        }
        if (maxCoord.func_177956_o() == this.func_174877_v().func_177956_o() || minCoord.func_177956_o() == this.func_174877_v().func_177956_o()) {
            ++facesMatching;
        }
        if (maxCoord.func_177952_p() == this.func_174877_v().func_177952_p() || minCoord.func_177952_p() == this.func_174877_v().func_177952_p()) {
            ++facesMatching;
        }
        if (facesMatching == 1) {
            this.outwards = maxCoord.func_177958_n() == this.func_174877_v().func_177958_n() ? EnumFacing.EAST : (minCoord.func_177958_n() == this.func_174877_v().func_177958_n() ? EnumFacing.WEST : (maxCoord.func_177952_p() == this.func_174877_v().func_177952_p() ? EnumFacing.SOUTH : (minCoord.func_177952_p() == this.func_174877_v().func_177952_p() ? EnumFacing.NORTH : (maxCoord.func_177956_o() == this.func_174877_v().func_177956_o() ? EnumFacing.UP : EnumFacing.DOWN))));
        }
        if (((BlockGreenhouse)this.func_145838_q()).getGreenhouseType() != BlockGreenhouseType.HATCH_OUTPUT && this.outwards != null) {
            this.outwards = this.outwards.func_176734_d();
        }
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.getOutwardsTile() != null && (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return (T)this.getOutwardsTile().getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.getOutwardsTile() != null && (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return this.getOutwardsTile().hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public World getWorldObj() {
        return this.field_145850_b;
    }
}

