/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.logics;

import forestry.api.greenhouse.DefaultGreenhouseLogic;
import forestry.api.greenhouse.GreenhouseManager;
import forestry.api.greenhouse.IInternalBlock;
import forestry.api.greenhouse.ITerrainRecipe;
import forestry.api.multiblock.IGreenhouseController;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GreenhouseLogicTerrain
extends DefaultGreenhouseLogic {
    private static final int TIME = 160;
    private IInternalBlock[] internalBlocks = new IInternalBlock[0];
    private World world;
    private int timeUntilNextTerrain;

    public GreenhouseLogicTerrain(IGreenhouseController controller) {
        super(controller, "Terrain");
        this.world = controller.getWorldObj();
        this.timeUntilNextTerrain = 160;
    }

    @Override
    public void work() {
        if (this.world.field_72995_K || this.controller == null || !this.controller.isAssembled() || this.internalBlocks.length == 0) {
            return;
        }
        if (this.timeUntilNextTerrain > 0) {
            --this.timeUntilNextTerrain;
            if (this.timeUntilNextTerrain <= 0) {
                IBlockState blockState;
                ITerrainRecipe recipe;
                IInternalBlock internalBlock = this.internalBlocks[this.world.field_73012_v.nextInt(this.internalBlocks.length)];
                BlockPos blockPos = internalBlock.getPos();
                if (this.world.func_175667_e(blockPos) && !this.world.func_175623_d(blockPos) && (recipe = GreenhouseManager.greenhouseHelper.getValidTerrainRecipe(blockState = this.world.func_180495_p(blockPos), this.controller.getRegion().getPosition(blockPos).getInfo())) != null && recipe.getChance() > this.world.field_73012_v.nextFloat()) {
                    this.world.func_175656_a(blockPos, recipe.getResult());
                }
                this.timeUntilNextTerrain = 160;
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Time", this.timeUntilNextTerrain);
        return super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.timeUntilNextTerrain = nbt.func_74762_e("Time");
        if (this.timeUntilNextTerrain <= 0) {
            this.timeUntilNextTerrain = 160;
        }
    }

    @Override
    public void onMachineAssembled() {
        this.internalBlocks = this.controller.getInternalBlocks().toArray(new IInternalBlock[0]);
    }

    @Override
    public void onMachineDisassembled() {
        this.internalBlocks = new IInternalBlock[0];
    }
}

