/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse;

import com.google.common.base.Preconditions;
import forestry.api.climate.IClimateInfo;
import forestry.api.core.ForestryAPI;
import forestry.api.greenhouse.GreenhouseManager;
import forestry.core.PluginCore;
import forestry.core.climate.ClimateInfo;
import forestry.core.items.EnumElectronTube;
import forestry.core.items.ItemRegistryCore;
import forestry.core.recipes.RecipeUtil;
import forestry.greenhouse.EventHandlerGreenhouse;
import forestry.greenhouse.GreenhouseHelper;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.blocks.BlockRegistryGreenhouse;
import forestry.greenhouse.logics.GreenhouseLogicGreenhouseEffect;
import forestry.greenhouse.logics.GreenhouseLogicTerrain;
import forestry.greenhouse.proxy.ProxyGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouseButterflyHatch;
import forestry.greenhouse.tiles.TileGreenhouseClimateControl;
import forestry.greenhouse.tiles.TileGreenhouseControl;
import forestry.greenhouse.tiles.TileGreenhouseDoor;
import forestry.greenhouse.tiles.TileGreenhouseDryer;
import forestry.greenhouse.tiles.TileGreenhouseFan;
import forestry.greenhouse.tiles.TileGreenhouseGearbox;
import forestry.greenhouse.tiles.TileGreenhouseHatch;
import forestry.greenhouse.tiles.TileGreenhouseHeater;
import forestry.greenhouse.tiles.TileGreenhouseHumidifier;
import forestry.greenhouse.tiles.TileGreenhousePlain;
import forestry.greenhouse.tiles.TileGreenhouseValve;
import forestry.greenhouse.tiles.TileGreenhouseWindow;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.registry.GameRegistry;

@ForestryPlugin(pluginID="forestry.greenhouse", name="Greenhouse", author="Nedelosk", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.greenhouse.description")
public class PluginGreenhouse
extends BlankForestryPlugin {
    @SidedProxy(clientSide="forestry.greenhouse.proxy.ProxyGreenhouseClient", serverSide="forestry.greenhouse.proxy.ProxyGreenhouse")
    public static ProxyGreenhouse proxy;
    @Nullable
    private static BlockRegistryGreenhouse blocks;

    public static BlockRegistryGreenhouse getBlocks() {
        Preconditions.checkState((blocks != null ? 1 : 0) != 0);
        return blocks;
    }

    @Override
    public void setupAPI() {
        GreenhouseManager.greenhouseHelper = new GreenhouseHelper();
    }

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistryGreenhouse();
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerGreenhouse());
        proxy.initializeModels();
        GreenhouseManager.greenhouseHelper.registerGreenhouseLogic(GreenhouseLogicGreenhouseEffect.class);
        GreenhouseManager.greenhouseHelper.registerGreenhouseLogic(GreenhouseLogicTerrain.class);
        GreenhouseManager.greenhouseHelper.registerTerrainRecipe(Blocks.field_150346_d, Blocks.field_150354_m.func_176223_P(), (IClimateInfo)new ClimateInfo(1.2f, -1.0f), (IClimateInfo)new ClimateInfo(-1.0f, -1.0f), 0.5f);
        GreenhouseManager.greenhouseHelper.registerTerrainRecipe((Block)Blocks.field_150349_c, Blocks.field_150354_m.func_176223_P(), (IClimateInfo)new ClimateInfo(1.2f, -1.0f), (IClimateInfo)new ClimateInfo(-1.0f, -1.0f), 0.5f);
        GreenhouseManager.greenhouseHelper.registerTerrainRecipe(Blocks.field_150458_ak, Blocks.field_150354_m.func_176223_P(), (IClimateInfo)new ClimateInfo(1.2f, -1.0f), (IClimateInfo)new ClimateInfo(-1.0f, -1.0f), 0.5f);
    }

    @Override
    public void doInit() {
        super.doInit();
        GameRegistry.registerTileEntity(TileGreenhouseFan.class, (String)"forestry.GreenhouseFan");
        GameRegistry.registerTileEntity(TileGreenhouseHeater.class, (String)"forestry.GreenhouseHeater");
        GameRegistry.registerTileEntity(TileGreenhouseDryer.class, (String)"forestry.GreenhouseDryer");
        GameRegistry.registerTileEntity(TileGreenhouseHumidifier.class, (String)"forestry.GreenhouseSprinkler");
        GameRegistry.registerTileEntity(TileGreenhouseValve.class, (String)"forestry.GreenhouseValve");
        GameRegistry.registerTileEntity(TileGreenhouseGearbox.class, (String)"forestry.GreenhouseGearbox");
        GameRegistry.registerTileEntity(TileGreenhouseControl.class, (String)"forestry.GreenhouseController");
        GameRegistry.registerTileEntity(TileGreenhousePlain.class, (String)"forestry.GreenhousePlain");
        GameRegistry.registerTileEntity(TileGreenhouseDoor.class, (String)"forestry.GreenhouseDoor");
        GameRegistry.registerTileEntity(TileGreenhouseHatch.class, (String)"forestry.GreenhouseHatch");
        GameRegistry.registerTileEntity(TileGreenhouseClimateControl.class, (String)"forestry.GreenhouseClimateControl");
        GameRegistry.registerTileEntity(TileGreenhouseWindow.class, (String)"forestry.GreenhouseWindow");
        if (ForestryAPI.enabledPlugins.contains("forestry.lepidopterology")) {
            GameRegistry.registerTileEntity(TileGreenhouseButterflyHatch.class, (String)"forestry.GreenhouseButterflyHatch");
        }
    }

    @Override
    public void registerRecipes() {
        ItemRegistryCore coreItems = PluginCore.getItems();
        BlockRegistryGreenhouse blocks = PluginGreenhouse.getBlocks();
        BlockGreenhouse greenhousePlainBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN);
        RecipeUtil.addRecipe(new ItemStack((Block)greenhousePlainBlock, 4), "###", "#X#", "###", Character.valueOf('X'), Blocks.field_150336_V, Character.valueOf('#'), coreItems.craftingMaterial.getCamouflagedPaneling());
        BlockGreenhouse greenhouseGlassBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.GLASS);
        RecipeUtil.addRecipe(new ItemStack((Block)greenhouseGlassBlock, 4), "###", "#X#", "###", Character.valueOf('X'), "blockGlass", Character.valueOf('#'), coreItems.craftingMaterial.getCamouflagedPaneling());
        BlockGreenhouse greenhouseHatchInputBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.HATCH_INPUT);
        RecipeUtil.addRecipe(greenhouseHatchInputBlock, "TXT", "#H#", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('H'), "trapdoorWood", Character.valueOf('#'), "gearTin", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.BRONZE, 1));
        BlockGreenhouse greenhouseHatchOutputBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.HATCH_OUTPUT);
        RecipeUtil.addRecipe(greenhouseHatchOutputBlock, "#H#", "TXT", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('H'), "trapdoorWood", Character.valueOf('#'), "gearTin", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.BRONZE, 1));
        BlockGreenhouse greenhouseControlBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.CONTROL);
        RecipeUtil.addRecipe(greenhouseControlBlock, " X ", "#T#", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('#'), "dustRedstone", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.GOLD, 1));
        BlockGreenhouse greenhouseGearBoxBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.GEARBOX);
        RecipeUtil.addRecipe(greenhouseGearBoxBlock, " X ", "###", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('#'), "gearTin");
        BlockGreenhouse greenhouseValveBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.VALVE);
        RecipeUtil.addRecipe(greenhouseValveBlock, " X ", "#G#", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('#'), "blockGlass", Character.valueOf('G'), "gearTin");
        BlockGreenhouse greenhouseHeaterBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.HEATER);
        RecipeUtil.addRecipe(greenhouseHeaterBlock, "T#T", "#X#", "T#T", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('#'), "ingotTin", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.GOLD, 1));
        BlockGreenhouse greenhouseFanlock = blocks.getGreenhouseBlock(BlockGreenhouseType.FAN);
        RecipeUtil.addRecipe(greenhouseFanlock, "T#T", "#X#", "T#T", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('#'), "ingotIron", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.TIN, 1));
        BlockGreenhouse greenhouseDryerBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.DEHUMIDIFIER);
        RecipeUtil.addRecipe(greenhouseDryerBlock, "T#T", "#X#", "T#T", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('#'), "ingotTin", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.BLAZE, 1));
        BlockGreenhouse greenhouseSprinklerBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.HUMIDIFIER);
        RecipeUtil.addRecipe(greenhouseSprinklerBlock, "T#T", "#X#", "T#T", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('#'), "ingotTin", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.LAPIS, 1));
        BlockGreenhouse greenhouseDoorBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.DOOR);
        RecipeUtil.addRecipe(greenhouseDoorBlock, true, "GG ", "GG ", "GG ", Character.valueOf('G'), blocks.getGreenhouseBlock(BlockGreenhouseType.GLASS));
        BlockGreenhouse greenhouseWindowBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.WINDOW);
        RecipeUtil.addRecipe(greenhouseWindowBlock, true, "GGS", "GGG", "GGS", Character.valueOf('G'), blocks.getGreenhouseBlock(BlockGreenhouseType.GLASS), Character.valueOf('S'), "stickWood");
        BlockGreenhouse greenhouseWindowRoofBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.WINDOW_UP);
        RecipeUtil.addRecipe(greenhouseWindowRoofBlock, true, "SGS", "GGG", "GGG", Character.valueOf('G'), blocks.getGreenhouseBlock(BlockGreenhouseType.GLASS), Character.valueOf('S'), "stickWood");
        BlockGreenhouse greenhouseClimateControlBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.CLIMATE_CONTROL);
        RecipeUtil.addRecipe(greenhouseClimateControlBlock, true, "IRG", "EBT", "GRI", Character.valueOf('B'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('I'), "ingotBronze", Character.valueOf('G'), "gearTin", Character.valueOf('R'), "dustRedstone", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.LAPIS, 1), Character.valueOf('E'), coreItems.tubes.get(EnumElectronTube.BLAZE, 1));
        if (ForestryAPI.enabledPlugins.contains("forestry.lepidopterology")) {
            BlockGreenhouse greenhouseButterflyHatchBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.BUTTERFLY_HATCH);
            RecipeUtil.addRecipe(greenhouseButterflyHatchBlock, true, "IRG", "SBS", "GRI", Character.valueOf('R'), "dustRedstone", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "gearCopper", Character.valueOf('B'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('S'), coreItems.craftingMaterial.getSilkWisp());
        }
    }
}

