/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse;

import com.google.common.base.Preconditions;
import forestry.api.climate.IClimateInfo;
import forestry.api.greenhouse.IGreenhouseHelper;
import forestry.api.greenhouse.IGreenhouseLogic;
import forestry.api.greenhouse.ITerrainRecipe;
import forestry.api.multiblock.IGreenhouseController;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockRegistry;
import forestry.core.utils.ClimateUtil;
import forestry.greenhouse.TerrainRecipeBlock;
import forestry.greenhouse.TerrainRecipeState;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.InternalBlockCheck;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GreenhouseHelper
implements IGreenhouseHelper {
    private final List<Class<? extends IGreenhouseLogic>> greenhouseLogics = new ArrayList<Class<? extends IGreenhouseLogic>>();
    private final List<ITerrainRecipe> terrainRecipes = new ArrayList<ITerrainRecipe>();

    @Override
    @Nullable
    public IGreenhouseController getGreenhouseController(World world, BlockPos pos) {
        for (IMultiblockControllerInternal controllerInternal : MultiblockRegistry.getControllersFromWorld(world)) {
            if (!(controllerInternal instanceof IGreenhouseControllerInternal) || !controllerInternal.isAssembled() || !GreenhouseHelper.isPositionInGreenhouse((IGreenhouseControllerInternal)controllerInternal, pos)) continue;
            return (IGreenhouseController)((Object)controllerInternal);
        }
        return null;
    }

    private static boolean isPositionInGreenhouse(IGreenhouseControllerInternal controller, BlockPos pos) {
        InternalBlockCheck checkBlock = new InternalBlockCheck(pos);
        return controller.getInternalBlocks().contains(checkBlock);
    }

    @Override
    public void registerGreenhouseLogic(Class<? extends IGreenhouseLogic> logic) {
        if (!this.greenhouseLogics.contains(logic)) {
            this.greenhouseLogics.add(logic);
        }
    }

    @Override
    public List<Class<? extends IGreenhouseLogic>> getGreenhouseLogics() {
        return this.greenhouseLogics;
    }

    @Override
    public void registerTerrainRecipe(IBlockState inputState, IBlockState outputState, IClimateInfo minClimate, IClimateInfo maxClimate, float chance) {
        Preconditions.checkNotNull((Object)inputState);
        Preconditions.checkNotNull((Object)outputState);
        Preconditions.checkNotNull((Object)minClimate);
        Preconditions.checkNotNull((Object)maxClimate);
        this.terrainRecipes.add(new TerrainRecipeState(inputState, outputState, minClimate, maxClimate, chance));
    }

    @Override
    public void registerTerrainRecipe(Block inputBlock, IBlockState outputState, IClimateInfo minClimate, IClimateInfo maxClimate, float chance) {
        Preconditions.checkNotNull((Object)inputBlock);
        Preconditions.checkNotNull((Object)outputState);
        Preconditions.checkNotNull((Object)minClimate);
        Preconditions.checkNotNull((Object)maxClimate);
        this.terrainRecipes.add(new TerrainRecipeBlock(inputBlock, outputState, minClimate, maxClimate, chance));
    }

    @Override
    public ITerrainRecipe getValidTerrainRecipe(IBlockState blockState, IClimateInfo climateInfo) {
        for (ITerrainRecipe recipe : this.terrainRecipes) {
            if (!recipe.matches(blockState) || !ClimateUtil.isWithinLimits(recipe.getMinClimate(), recipe.getMaxClimate(), climateInfo)) continue;
            return recipe;
        }
        return null;
    }
}

