/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.blocks.BlockPile;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.tiles.TilePile;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.models.BlankModel;
import forestry.core.models.DefaultTextureGetter;
import forestry.core.tiles.TileUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelProcessingHelper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelWoodPile
extends BlankModel {
    private final Function<ResourceLocation, TextureAtlasSprite> textureGetter = new DefaultTextureGetter();
    @Nullable
    private static IModel modelWoodPileItem;
    @Nullable
    private static IModel modelWoodPileBlock;
    private static final Cache<String, IBakedModel> blockCache;
    private static final Cache<String, IBakedModel> itemCache;

    public static void onModelBake(ModelBakeEvent event) {
        blockCache.invalidateAll();
        itemCache.invalidateAll();
    }

    @Override
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state instanceof IExtendedBlockState) {
            BlockPos pos;
            IExtendedBlockState stateExtended = (IExtendedBlockState)state;
            IBlockAccess world = (IBlockAccess)stateExtended.getValue((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS);
            TilePile pile = TileUtil.getTile(world, pos = (BlockPos)stateExtended.getValue((IUnlistedProperty)UnlistedBlockPos.POS), TilePile.class);
            if (pile == null) {
                return Collections.emptyList();
            }
            IAlleleTreeSpecies treeSpecies = pile.getTreeSpecies();
            if (modelWoodPileBlock == null) {
                try {
                    modelWoodPileBlock = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("forestry:block/woodPile"));
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
                if (modelWoodPileBlock == null) {
                    return Collections.emptyList();
                }
            }
            IBakedModel model = this.bakeModel(treeSpecies, false);
            return model.func_188616_a(state, side, rand);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean func_177555_b() {
        return false;
    }

    @Override
    public boolean func_177556_c() {
        return true;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return TreeDefinition.Oak.getGenome().getPrimary().getWoodProvider().getSprite(false);
    }

    @Override
    protected ItemOverrideList createOverrides() {
        return new PileItemOverrideList();
    }

    private IBakedModel bakeModel(IAlleleTreeSpecies treeSpecies, boolean isItem) {
        String treeUID;
        ImmutableMap.Builder textures = ImmutableMap.builder();
        Cache<String, IBakedModel> map = isItem ? itemCache : blockCache;
        IBakedModel model = (IBakedModel)map.getIfPresent((Object)(treeUID = treeSpecies.getUID()));
        if (model == null) {
            textures.put((Object)"woodBark", (Object)treeSpecies.getWoodProvider().getSprite(false).func_94215_i());
            textures.put((Object)"woodTop", (Object)treeSpecies.getWoodProvider().getSprite(true).func_94215_i());
            IModel retextureWoodPile = ModelProcessingHelper.retexture((IModel)(isItem ? modelWoodPileItem : modelWoodPileBlock), (ImmutableMap)textures.build());
            model = retextureWoodPile.bake((IModelState)ModelRotation.X0_Y0, isItem ? DefaultVertexFormats.field_176599_b : DefaultVertexFormats.field_176600_a, this.textureGetter);
            map.put((Object)treeUID, (Object)model);
        }
        return model;
    }

    static {
        blockCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        itemCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    private class PileItemOverrideList
    extends ItemOverrideList {
        public PileItemOverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            IAlleleTreeSpecies treeSpecies;
            if (modelWoodPileItem == null) {
                try {
                    modelWoodPileItem = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("forestry:item/woodPile"));
                }
                catch (Exception e) {
                    return originalModel;
                }
                if (modelWoodPileItem == null) {
                    return originalModel;
                }
            }
            if ((treeSpecies = BlockPile.getTreeSpecies(stack)) == null) {
                treeSpecies = (IAlleleTreeSpecies)TreeManager.treeRoot.getDefaultTemplate()[TreeManager.treeRoot.getSpeciesChromosomeType().ordinal()];
            }
            return ModelWoodPile.this.bakeModel(treeSpecies, true);
        }
    }
}

