/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse.tiles;

import javax.annotation.Nullable;
import java.io.IOException;

import com.mojang.authlib.GameProfile;
import forestry.api.core.CamouflageManager;
import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.greenhouse.GreenhouseEvents.CamouflageChangeEvent;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.api.multiblock.MultiblockTileEntityBase;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.CamouflageSelectionType;
import forestry.core.network.packets.PacketCamouflageSelectServer;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.PlayerUtil;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileGreenhouseHatch extends MultiblockTileEntityBase<MultiblockLogicGreenhouse> implements IGreenhouseComponent, IStreamableGui, IErrorLogicSource, IOwnedTile, ICamouflageHandler, ICamouflagedTile {

	@Nullable
	private EnumFacing outwards;
	private ItemStack camouflageBlock;
	@Nullable
	private GameProfile owner;

	public TileGreenhouseHatch() {
		super(new MultiblockLogicGreenhouse());
		outwards = null;
		camouflageBlock = ItemStack.field_190927_a;
	}

	@Nullable
	public EnumFacing getOutwardsDir() {
		return outwards;
	}

	@Override
	public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
		field_145850_b.func_175685_c(func_174877_v(), field_145850_b.func_180495_p(field_174879_c).func_177230_c(), false);
		func_70296_d();

		recalculateOutwardsDirection(minCoord, maxCoord);
	}

	@Override
	public void onMachineBroken() {
		field_145850_b.func_175685_c(func_174877_v(), field_145850_b.func_180495_p(field_174879_c).func_177230_c(), false);
		func_70296_d();
		outwards = null;
	}

	/* SAVING & LOADING */
	@Override
	public void func_145839_a(NBTTagCompound data) {
		super.func_145839_a(data);

		if (data.func_74764_b("CamouflageBlock")) {
			camouflageBlock = new ItemStack(data.func_74775_l("CamouflageBlock"));
		}

		if (data.func_74764_b("owner")) {
			NBTTagCompound ownerNbt = data.func_74775_l("owner");
			this.owner = PlayerUtil.readGameProfileFromNBT(ownerNbt);
		}
	}


	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound data) {
		data = super.func_189515_b(data);

		if (!camouflageBlock.func_190926_b()) {
			NBTTagCompound nbtTag = new NBTTagCompound();
			camouflageBlock.func_77955_b(nbtTag);
			data.func_74782_a("CamouflageBlock", nbtTag);
		}

		if (this.owner != null) {
			NBTTagCompound nbt = new NBTTagCompound();
			PlayerUtil.writeGameProfile(nbt, owner);
			data.func_74782_a("owner", nbt);
		}

		return data;
	}

	/* IMultiblockComponent */
	@Nullable
	@Override
	public final GameProfile getOwner() {
		return owner;
	}

	public final void setOwner(GameProfile owner) {
		this.owner = owner;
	}

	/* CONSTRUCTION MATERIAL */
	@Override
	public boolean setCamouflageBlock(String type, ItemStack camouflageBlock, boolean sendClientUpdate) {
		if (!ItemStackUtil.isIdenticalItem(camouflageBlock, this.camouflageBlock)) {
			this.camouflageBlock = camouflageBlock;

			if (sendClientUpdate && field_145850_b != null && field_145850_b.field_72995_K) {
				Proxies.net.sendToServer(new PacketCamouflageSelectServer(this, type, CamouflageSelectionType.TILE));
			}
			MinecraftForge.EVENT_BUS.post(new CamouflageChangeEvent(getMultiblockLogic().getController(), this, this, type));
			return true;
		}
		return false;
	}

	@Override
	public ItemStack getCamouflageBlock(String type) {
		return camouflageBlock;
	}

	@Override
	public ItemStack getDefaultCamouflageBlock(String type) {
		return ItemStack.field_190927_a;
	}

	@Override
	public boolean canHandleType(String type) {
		return type.equals(getCamouflageType());
	}

	/* IStreamableGui */
	@Override
	public void writeGuiData(PacketBufferForestry data) {
		getMultiblockLogic().getController().writeGuiData(data);
	}

	@Override
	public void readGuiData(PacketBufferForestry data) throws IOException {
		getMultiblockLogic().getController().readGuiData(data);
	}

	/* TILEFORESTRY */
	@Override
	protected void encodeDescriptionPacket(NBTTagCompound packetData) {
		super.encodeDescriptionPacket(packetData);
		if (!camouflageBlock.func_190926_b()) {
			NBTTagCompound nbtTag = new NBTTagCompound();
			camouflageBlock.func_77955_b(nbtTag);
			packetData.func_74782_a("CamouflageBlock", nbtTag);
		}
	}

	@Override
	protected void decodeDescriptionPacket(NBTTagCompound packetData) {
		super.decodeDescriptionPacket(packetData);
		if (packetData.func_74764_b("CamouflageBlock")) {
			setCamouflageBlock(getCamouflageType(), new ItemStack(packetData.func_74775_l("CamouflageBlock")), true);
		}
	}

	/* IErrorLogicSource */
	@Override
	public IErrorLogic getErrorLogic() {
		return getMultiblockLogic().getController().getErrorLogic();
	}

	@Override
	public IOwnerHandler getOwnerHandler() {
		return getMultiblockLogic().getController().getOwnerHandler();
	}

	@Override
	public String getCamouflageType() {
		if (func_145838_q() instanceof BlockGreenhouse && ((BlockGreenhouse) func_145838_q()).getGreenhouseType() == BlockGreenhouseType.GLASS) {
			return CamouflageManager.GLASS;
		}
		return CamouflageManager.BLOCK;
	}

	@Nullable
	private TileEntity getOutwardsTile() {
		if (outwards == null || field_145850_b == null || field_174879_c == null) {
			return null;
		}
		return field_145850_b.func_175625_s(func_174877_v().func_177972_a(outwards));
	}

	public void recalculateOutwardsDirection(BlockPos minCoord, BlockPos maxCoord) {
		outwards = null;

		int facesMatching = 0;
		if (maxCoord.func_177958_n() == func_174877_v().func_177958_n() || minCoord.func_177958_n() == func_174877_v().func_177958_n()) {
			facesMatching++;
		}
		if (maxCoord.func_177956_o() == func_174877_v().func_177956_o() || minCoord.func_177956_o() == func_174877_v().func_177956_o()) {
			facesMatching++;
		}
		if (maxCoord.func_177952_p() == func_174877_v().func_177952_p() || minCoord.func_177952_p() == func_174877_v().func_177952_p()) {
			facesMatching++;
		}
		if (facesMatching == 1) {
			if (maxCoord.func_177958_n() == func_174877_v().func_177958_n()) {
				outwards = EnumFacing.EAST;
			} else if (minCoord.func_177958_n() == func_174877_v().func_177958_n()) {
				outwards = EnumFacing.WEST;
			} else if (maxCoord.func_177952_p() == func_174877_v().func_177952_p()) {
				outwards = EnumFacing.SOUTH;
			} else if (minCoord.func_177952_p() == func_174877_v().func_177952_p()) {
				outwards = EnumFacing.NORTH;
			} else if (maxCoord.func_177956_o() == func_174877_v().func_177956_o()) {
				outwards = EnumFacing.UP;
			} else {
				outwards = EnumFacing.DOWN;
			}
		}

		if (((BlockGreenhouse) func_145838_q()).getGreenhouseType() != BlockGreenhouseType.HATCH_OUTPUT && outwards != null) {
			outwards = outwards.func_176734_d();
		}
	}

	@Override
	@Nullable
	public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
		if (getOutwardsTile() != null) {
			if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
				return getOutwardsTile().getCapability(capability, facing);
			}
		}
		return super.getCapability(capability, facing);
	}

	@Override
	public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
		if (getOutwardsTile() != null) {
			if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
				return getOutwardsTile().hasCapability(capability, facing);
			}
		}
		return super.hasCapability(capability, facing);
	}

	@Override
	public World getWorldObj() {
		return field_145850_b;
	}
}
