/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.arboriculture.render;

import static forestry.arboriculture.multiblock.EnumPilePosition.*;

import forestry.api.arboriculture.EnumPileType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.blocks.BlockPile;
import forestry.arboriculture.multiblock.EnumPilePosition;
import forestry.arboriculture.multiblock.ICharcoalPileControllerInternal;
import forestry.arboriculture.tiles.TilePile;
import forestry.core.multiblock.MultiblockLogic;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class CharcoalPileRenderer extends TileEntitySpecialRenderer<TilePile> {
	public CharcoalPileRenderer() {
	}

	@Override
	public void func_180535_a(TilePile pile, double x, double y, double z, float p_147500_8_, int destroyStage) {
		IBlockState state = pile.func_145831_w().func_180495_p(pile.func_174877_v());
		if (!(state.func_177230_c() instanceof BlockPile)) {
			return;
		}

		EnumPilePosition pilePosition = state.func_177229_b(BlockPile.PILE_POSITION);
		MultiblockLogic<ICharcoalPileControllerInternal> logic = pile.getMultiblockLogic();
		if (pilePosition != EnumPilePosition.INTERIOR && logic.isConnected() && logic.getController() != null) {
			GlStateManager.func_179094_E();
			GlStateManager.func_179137_b(x + 0.5F, y + 0.5F, z + 0.5F);
			GlStateManager.func_179094_E();
			GlStateManager.func_179140_f();
			Proxies.common.getClientInstance().field_71446_o.func_110577_a(TextureMap.field_110575_b);

			boolean withWood = pile.getPileType() != EnumPileType.ASH;
			boolean isOnTop = logic.getController().getMaximumCoord().func_177956_o() == pile.func_174877_v().func_177956_o();
			// TODO Add brightness to the textures.
			int brightness = state.func_185889_a(pile.func_145831_w(), pile.func_174877_v());
			IAlleleTreeSpecies treeSpecies = pile.getNextWoodPile();
			if (treeSpecies == null) {
				treeSpecies = (IAlleleTreeSpecies) TreeManager.treeRoot.getDefaultTemplate()[TreeManager.treeRoot.getSpeciesChromosomeType().ordinal()];
			}
			TextureAtlasSprite dirtSprite;
			if (pile.getPileType() == EnumPileType.ASH) {
				dirtSprite = TextureManager.registerSprite(new ResourceLocation("forestry:blocks/ash"));
			} else {
				dirtSprite = TextureManager.registerSprite(new ResourceLocation("forestry:blocks/loam"));
			}
			TextureAtlasSprite woodSprite = treeSpecies.getWoodProvider().getSprite(false);
			TextureAtlasSprite woodTopSprite = treeSpecies.getWoodProvider().getSprite(true);
			if (pilePosition == BACK) {
				renderPileSide(withWood, dirtSprite, woodSprite, woodTopSprite, brightness);
			} else if (pilePosition == FRONT) {
				GlStateManager.func_179114_b(180, 0F, 0F, 1F);
				GlStateManager.func_179114_b(180.0F, 1.0F, 0.0F, 0.0F);

				renderPileSide(withWood, dirtSprite, woodSprite, woodTopSprite, brightness);
			} else if (pilePosition == SIDE_LEFT) {
				GlStateManager.func_179114_b(90.0F, 0.0F, 1.0F, 0.0F);

				renderPileSide(withWood, dirtSprite, woodSprite, woodTopSprite, brightness);
			} else if (pilePosition == SIDE_RIGHT) {
				GlStateManager.func_179114_b(180, 0F, 1F, 0F);
				GlStateManager.func_179114_b(90.0F, 0.0F, 1.0F, 0.0F);

				renderPileSide(withWood, dirtSprite, woodSprite, woodTopSprite, brightness);
			} else if (pilePosition == CORNER_BACK_RIGHT) {
				GlStateManager.func_179114_b(180, 0F, 1F, 0F);
				GlStateManager.func_179114_b(90.0F, 0.0F, 1.0F, 0.0F);

				renderPileCorner(withWood, dirtSprite, woodSprite, woodTopSprite, brightness, isOnTop);
			} else if (pilePosition == CORNER_BACK_LEFT) {
				GlStateManager.func_179114_b(90, 0F, 1F, 0F);
				GlStateManager.func_179114_b(90.0F, 0.0F, 1.0F, 0.0F);

				renderPileCorner(withWood, dirtSprite, woodSprite, woodTopSprite, brightness, isOnTop);
			} else if (pilePosition == CORNER_FRONT_LEFT) {
				GlStateManager.func_179114_b(90.0F, 0.0F, 1.0F, 0.0F);

				renderPileCorner(withWood, dirtSprite, woodSprite, woodTopSprite, brightness, isOnTop);
			} else if (pilePosition == CORNER_FRONT_RIGHT) {
				GlStateManager.func_179114_b(270, 0F, 1F, 0F);
				GlStateManager.func_179114_b(90.0F, 0.0F, 1.0F, 0.0F);

				renderPileCorner(withWood, dirtSprite, woodSprite, woodTopSprite, brightness, isOnTop);
			}
			GlStateManager.func_179145_e();
			GlStateManager.func_179121_F();
			GlStateManager.func_179121_F();
		}
	}

	public static void renderPileSide(boolean withWood, TextureAtlasSprite dirtSprite, TextureAtlasSprite woodSprite, TextureAtlasSprite woodTopSprite, int brightness) {
		Tessellator t = Tessellator.func_178181_a();
		VertexBuffer buffer = t.func_178180_c();
		buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);

		buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94210_h()).func_181675_d();
		buffer.func_181662_b(-0.5, -0.5, 0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94210_h()).func_181675_d();

		buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94210_h()).func_181675_d();
		buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94210_h()).func_181675_d();
		buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(0.5, 0.5, 0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94206_g()).func_181675_d();

		buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(-0.5, -0.5, 0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94210_h()).func_181675_d();
		buffer.func_181662_b(0.5, 0.5, 0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94210_h()).func_181675_d();

		buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(-0.5, -0.5, 0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94210_h()).func_181675_d();
		buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94210_h()).func_181675_d();

		buffer.func_181662_b(0.5, 0.5, 0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94210_h()).func_181675_d();
		buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94210_h()).func_181675_d();

		if (withWood) {
			buffer.func_181662_b(0.1, 0.3, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(0.1, -0.5, -0.5).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.1, -0.5, -0.7).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.1, 0.5, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();

			buffer.func_181662_b(0.1, 0.5, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(0.1, -0.5, -0.7).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(-0.1, -0.5, -0.7).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(-0.1, 0.5, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();

			buffer.func_181662_b(-0.1, 0.5, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(-0.1, -0.5, -0.7).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(-0.1, -0.5, -0.5).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(-0.1, 0.3, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();

			buffer.func_181662_b(-0.1, -0.5, -0.7).func_187315_a(woodTopSprite.func_94209_e(), woodTopSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.1, -0.5, -0.7).func_187315_a(woodTopSprite.func_94212_f(), woodTopSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.1, -0.5, -0.5).func_187315_a(woodTopSprite.func_94212_f(), woodTopSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(-0.1, -0.5, -0.5).func_187315_a(woodTopSprite.func_94209_e(), woodTopSprite.func_94210_h()).func_181675_d();

			buffer.func_181662_b(-0.5, 0.3, 0.5).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(-0.5, 0.3, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.5, 0.3, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(0.5, 0.3, 0.5).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();

			buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.5, 0.5, 0.5).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.5, 0.5, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(-0.5, 0.5, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();

			buffer.func_181662_b(0.5, 0.5, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.5, 0.3, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(-0.5, 0.3, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(-0.5, 0.5, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();
		}
		t.func_78381_a();
	}

	public static void renderPileCorner(boolean withWood, TextureAtlasSprite dirtSprite, TextureAtlasSprite woodSprite, TextureAtlasSprite woodTopSprite, int brightness, boolean isTop) {
		Tessellator t = Tessellator.func_178181_a();
		VertexBuffer buffer = t.func_178180_c();
		buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);

		buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94210_h()).func_181675_d();
		buffer.func_181662_b(-0.5, -0.5, 0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94210_h()).func_181675_d();

		buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94210_h()).func_181675_d();
		buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94210_h()).func_181675_d();
		buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94206_g()).func_181675_d();

		buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94210_h()).func_181675_d();
		buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94210_h()).func_181675_d();
		buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94206_g()).func_181675_d();

		buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(-0.5, -0.5, 0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94210_h()).func_181675_d();
		buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94210_h()).func_181675_d();

		buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(-0.5, -0.5, 0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94206_g()).func_181675_d();
		buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a(dirtSprite.func_94209_e(), dirtSprite.func_94210_h()).func_181675_d();
		buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a(dirtSprite.func_94212_f(), dirtSprite.func_94210_h()).func_181675_d();

		if (isTop && withWood) {

			buffer.func_181662_b(-0.3, 0.3, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(-0.3, -0.5, -0.5).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(-0.3, -0.5, -0.7).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(-0.3, 0.5, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();

			buffer.func_181662_b(-0.3, 0.5, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(-0.3, -0.5, -0.7).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(-0.5, -0.5, -0.7).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(-0.5, 0.5, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();

			buffer.func_181662_b(-0.5, 0.5, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(-0.5, -0.5, -0.7).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(-0.5, 0.3, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();

			buffer.func_181662_b(-0.5, -0.5, -0.7).func_187315_a(woodTopSprite.func_94209_e(), woodTopSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(-0.3, -0.5, -0.7).func_187315_a(woodTopSprite.func_94212_f(), woodTopSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(-0.3, -0.5, -0.5).func_187315_a(woodTopSprite.func_94212_f(), woodTopSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(woodTopSprite.func_94209_e(), woodTopSprite.func_94210_h()).func_181675_d();
		}
		t.func_78381_a();

		GlStateManager.func_179114_b(270.0F, 0.0F, 1.0F, 0.0F);
		if (withWood) {
			buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
			if (isTop) {

				buffer.func_181662_b(0.5, 0.3, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();
				buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();
				buffer.func_181662_b(0.5, -0.5, -0.7).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
				buffer.func_181662_b(0.5, 0.5, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();
				// Front
				buffer.func_181662_b(0.5, 0.5, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();
				buffer.func_181662_b(0.5, -0.5, -0.7).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();
				buffer.func_181662_b(0.3, -0.5, -0.7).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
				buffer.func_181662_b(0.3, 0.5, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();

				buffer.func_181662_b(0.3, 0.5, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();
				buffer.func_181662_b(0.3, -0.5, -0.7).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();
				buffer.func_181662_b(0.3, -0.5, -0.5).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
				buffer.func_181662_b(0.3, 0.3, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();

				buffer.func_181662_b(0.3, -0.5, -0.7).func_187315_a(woodTopSprite.func_94209_e(), woodTopSprite.func_94206_g()).func_181675_d();
				buffer.func_181662_b(0.5, -0.5, -0.7).func_187315_a(woodTopSprite.func_94212_f(), woodTopSprite.func_94206_g()).func_181675_d();
				buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a(woodTopSprite.func_94212_f(), woodTopSprite.func_94210_h()).func_181675_d();
				buffer.func_181662_b(0.3, -0.5, -0.5).func_187315_a(woodTopSprite.func_94209_e(), woodTopSprite.func_94210_h()).func_181675_d();
			}

			buffer.func_181662_b(0.3, 0.5, 0.5).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.5, 0.5, 0.5).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.5, 0.5, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(0.3, 0.5, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();

			buffer.func_181662_b(0.3, 0.3, 0.5).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(0.3, 0.3, 0.3).func_187315_a(woodSprite.func_94212_f(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.5, 0.3, 0.3).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.5, 0.3, 0.5).func_187315_a(woodSprite.func_94209_e(), woodSprite.func_94210_h()).func_181675_d();

			buffer.func_181662_b(0.5, 0.5, 0.3).func_187315_a(woodTopSprite.func_94209_e(), woodTopSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.5, 0.3, 0.3).func_187315_a(woodTopSprite.func_94209_e(), woodTopSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(0.3, 0.3, 0.3).func_187315_a(woodTopSprite.func_94212_f(), woodTopSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(0.3, 0.5, 0.3).func_187315_a(woodTopSprite.func_94212_f(), woodTopSprite.func_94206_g()).func_181675_d();

			buffer.func_181662_b(0.3, 0.5, 0.3).func_187315_a(woodTopSprite.func_94209_e(), woodTopSprite.func_94206_g()).func_181675_d();
			buffer.func_181662_b(0.3, 0.3, 0.3).func_187315_a(woodTopSprite.func_94209_e(), woodTopSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(0.3, 0.3, 0.5).func_187315_a(woodTopSprite.func_94212_f(), woodTopSprite.func_94210_h()).func_181675_d();
			buffer.func_181662_b(0.3, 0.5, 0.5).func_187315_a(woodTopSprite.func_94212_f(), woodTopSprite.func_94206_g()).func_181675_d();
			t.func_78381_a();
		}

		GlStateManager.func_179114_b(90.0F, 0.0F, 1.0F, 0.0F);
	}
}
