/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.multiblock;

import forestry.api.arboriculture.EnumPileType;
import forestry.api.arboriculture.IWoodProvider;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.multiblock.ICharcoalPileComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.apiculture.network.packets.PacketActiveUpdate;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.blocks.BlockPile;
import forestry.arboriculture.multiblock.CharcoalPileMultiblockSizeLimits;
import forestry.arboriculture.multiblock.ICharcoalPileControllerInternal;
import forestry.core.access.EnumAccess;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockRegistry;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.RectangularMultiblockControllerBase;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class CharcoalPileController
extends RectangularMultiblockControllerBase
implements ICharcoalPileControllerInternal {
    private int burnTime = 0;
    private int woodBurnTime;
    private boolean active = false;

    public CharcoalPileController(World world) {
        super(world, CharcoalPileMultiblockSizeLimits.instance);
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.worldObj != null) {
            if (this.worldObj.field_72995_K) {
                this.worldObj.func_175704_b(this.getMinimumCoord(), this.getMaximumCoord());
            } else {
                Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this), this.worldObj);
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockComponent part, NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    protected void onBlockAdded(IMultiblockComponent newComponent) {
    }

    @Override
    protected void onBlockRemoved(IMultiblockComponent oldComponent) {
    }

    @Override
    protected void onMachineRestored() {
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineAssembled() {
    }

    @Override
    protected void onMachineDisassembled() {
        this.setActive(false);
        this.burnTime = 0;
    }

    @Override
    protected void onAssimilate(IMultiblockControllerInternal assimilated) {
        if (!(assimilated instanceof CharcoalPileController)) {
            Log.warning("[%s] Charcoal Kiln @ %s is attempting to assimilate a non-Charcoal Kiln machine! That machine's data will be lost!", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", this.getReferenceCoord());
            return;
        }
    }

    @Override
    protected boolean updateServer(int tickCount) {
        if (!this.isActive()) {
            return false;
        }
        if (this.woodBurnTime == 0) {
            int comps = 0;
            int newBurnTime = 0;
            for (IMultiblockComponent part : this.connectedParts) {
                ICharcoalPileComponent comp = (ICharcoalPileComponent)part;
                if (comp.getTreeSpecies() == null) continue;
                ++comps;
                IWoodProvider woodProvider = comp.getTreeSpecies().getWoodProvider();
                newBurnTime += woodProvider.getCombustibility() * 1000;
            }
            this.woodBurnTime = newBurnTime / comps;
        }
        if (this.burnTime >= this.woodBurnTime) {
            for (IMultiblockComponent part : this.connectedParts) {
                BlockPos pos = part.getCoordinates();
                IBlockState state = this.worldObj.func_180495_p(pos);
                IBlockState ashPileState = PluginArboriculture.blocks.piles.get((Object)EnumPileType.ASH).func_176223_P().func_177226_a(BlockPile.PILE_POSITION, state.func_177229_b(BlockPile.PILE_POSITION));
                this.worldObj.func_175656_a(pos, ashPileState);
            }
            MultiblockRegistry.addDirtyController(this.worldObj, this);
        } else {
            ++this.burnTime;
        }
        return true;
    }

    @Override
    public String getUnlocalizedType() {
        return "for.multiblock.charcoal.pile.type";
    }

    @Override
    public BlockPos getCoordinates() {
        BlockPos coord = this.getReferenceCoord();
        return new BlockPos((Vec3i)coord);
    }

    @Override
    protected void updateClient(int tickCount) {
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.connectedParts.size() < this.getSizeLimits().getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException(Translator.translateToLocal("multiblock.error.small"));
        }
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.func_177958_n() - minimumCoord.func_177958_n() + 1;
        int deltaY = maximumCoord.func_177956_o() - minimumCoord.func_177956_o() + 1;
        int deltaZ = maximumCoord.func_177952_p() - minimumCoord.func_177952_p() + 1;
        int maxX = this.getSizeLimits().getMaximumXSize();
        int maxY = this.getSizeLimits().getMaximumYSize();
        int maxZ = this.getSizeLimits().getMaximumZSize();
        int minX = this.getSizeLimits().getMinimumXSize();
        int minY = this.getSizeLimits().getMinimumYSize();
        int minZ = this.getSizeLimits().getMinimumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("multiblock.error.large.x", maxX));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("multiblock.error.large.y", maxY));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("multiblock.error.large.z", maxZ));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("multiblock.error.small.x", minX));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("multiblock.error.small.y", minY));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("multiblock.error.small.z", minZ));
        }
        Class<?> myClass = this.getClass();
        ArrayList<BlockPos> components = new ArrayList<BlockPos>();
        for (int y = minimumCoord.func_177956_o(); y <= maximumCoord.func_177956_o(); ++y) {
            int partsOnLayer = 0;
            int layer = y - this.getMinimumCoord().func_177956_o();
            BlockPos currentMaximumCoord = maximumCoord.func_177982_a(-layer, 0, -layer);
            BlockPos currentMinimumCoord = minimumCoord.func_177982_a(layer, 0, layer);
            for (int z = currentMinimumCoord.func_177952_p(); z <= currentMaximumCoord.func_177952_p(); ++z) {
                for (int x = currentMinimumCoord.func_177958_n(); x <= currentMaximumCoord.func_177958_n(); ++x) {
                    IMultiblockComponent part;
                    BlockPos pos = new BlockPos(x, y, z);
                    TileEntity te = this.worldObj.func_175625_s(pos);
                    if (te instanceof IMultiblockComponent) {
                        part = (IMultiblockComponent)te;
                        if (!myClass.equals(part.getMultiblockLogic().getController().getClass())) {
                            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.invalid.part", Translator.translateToLocal(this.getUnlocalizedType())));
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == currentMinimumCoord.func_177958_n()) {
                        ++extremes;
                    }
                    if (z == currentMinimumCoord.func_177952_p()) {
                        ++extremes;
                    }
                    if (x == currentMaximumCoord.func_177958_n()) {
                        ++extremes;
                    }
                    if (y == currentMaximumCoord.func_177956_o()) {
                        ++extremes;
                    }
                    if (z == currentMaximumCoord.func_177952_p()) {
                        ++extremes;
                    }
                    if (extremes >= 1) {
                        int exteriorLevel = y - currentMinimumCoord.func_177956_o();
                        if (part != null) {
                            this.isGoodForExteriorLevel(part, exteriorLevel);
                        } else {
                            this.isBlockGoodForExteriorLevel(exteriorLevel, this.worldObj, pos);
                        }
                    } else if (part != null) {
                        this.isGoodForInterior(part);
                    } else {
                        this.isBlockGoodForInterior(this.worldObj, pos);
                    }
                    components.add(pos);
                    ++partsOnLayer;
                }
            }
            if (partsOnLayer >= 4) continue;
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.charcoal.pile.error.small"));
        }
        for (IMultiblockComponent comp : this.connectedParts) {
            if (components.contains(comp.getCoordinates())) continue;
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.charcoal.pile.error.large", comp.getCoordinates().func_177958_n(), comp.getCoordinates().func_177956_o(), comp.getCoordinates().func_177952_p()));
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data = super.writeToNBT(data);
        data.func_74768_a("BurnTime", this.burnTime);
        data.func_74757_a("IsActive", this.active);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.burnTime = data.func_74762_e("BurnTime");
        this.active = data.func_74767_n("IsActive");
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        this.writeToNBT(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        data.writeInt(this.burnTime);
        data.writeBoolean(this.active);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.burnTime = data.readInt();
        this.active = data.readBoolean();
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
    }

    @Override
    public EnumTemperature getTemperature() {
        return null;
    }

    @Override
    public EnumHumidity getHumidity() {
        return null;
    }

    @Override
    public float getExactTemperature() {
        return 0.0f;
    }

    @Override
    public float getExactHumidity() {
        return 0.0f;
    }

    @Override
    protected void isGoodForExteriorLevel(IMultiblockComponent part, int level) throws MultiblockValidationException {
        if (!(part instanceof ICharcoalPileComponent)) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.charcoal.pile.error.invalid.exterior", part.getCoordinates().func_177958_n(), part.getCoordinates().func_177956_o(), part.getCoordinates().func_177952_p()));
        }
        ICharcoalPileComponent component = (ICharcoalPileComponent)part;
        if (component.getPileType() != EnumPileType.DIRT) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.charcoal.pile.error.invalid.exterior", part.getCoordinates().func_177958_n(), part.getCoordinates().func_177956_o(), part.getCoordinates().func_177952_p()));
        }
    }

    @Override
    protected void isGoodForInterior(IMultiblockComponent part) throws MultiblockValidationException {
        if (!(part instanceof ICharcoalPileComponent)) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.charcoal.pile.error.invalid.interior", part.getCoordinates().func_177958_n(), part.getCoordinates().func_177956_o(), part.getCoordinates().func_177952_p()));
        }
        ICharcoalPileComponent component = (ICharcoalPileComponent)part;
        if (component.getPileType() != EnumPileType.WOOD) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.charcoal.pile.error.invalid.interior", part.getCoordinates().func_177958_n(), part.getCoordinates().func_177956_o(), part.getCoordinates().func_177952_p()));
        }
    }

    @Override
    public void onAssimilated(IMultiblockControllerInternal assimilator) {
    }

    @Override
    public BlockPos getMinimumCoord() {
        return super.getMinimumCoord();
    }

    @Override
    public BlockPos getMaximumCoord() {
        return super.getMaximumCoord();
    }
}

