/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.genetics.mutations;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import forestry.core.utils.Translator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class MutationConditionRequiresResource implements IMutationCondition {

	private final Set<IBlockState> acceptedBlockStates = new HashSet<>();
	private final String displayName;

	public MutationConditionRequiresResource(String oreDictName) {
		this.displayName = oreDictName;
		for (ItemStack ore : OreDictionary.getOres(oreDictName)) {
			if (ore != null) {
				Item oreItem = ore.func_77973_b();
				if (oreItem != null) {
					Block oreBlock = Block.func_149634_a(oreItem);
					if (oreBlock != null) {
						this.acceptedBlockStates.addAll(oreBlock.func_176194_O().func_177619_a());
					}
				}
			}
		}
	}

	public MutationConditionRequiresResource(IBlockState... acceptedBlockStates) {
		Collections.addAll(this.acceptedBlockStates, acceptedBlockStates);
		this.displayName = acceptedBlockStates[0].func_177230_c().func_149732_F();
	}

	@Override
	public float getChance(World world, BlockPos pos, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
		TileEntity tile;
		do {
			pos = pos.func_177977_b();
			tile = world.func_175625_s(pos);
		} while (tile instanceof IBeeHousing);

		IBlockState blockState = world.func_180495_p(pos);
		return this.acceptedBlockStates.contains(blockState) ? 1 : 0;
	}

	@Override
	public String getDescription() {
		return Translator.translateToLocalFormatted("for.mutation.condition.resource", displayName);
	}
}
