/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalState;
import forestry.api.mail.PostManager;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.tiles.TileBase;
import forestry.mail.EnumDeliveryState;
import forestry.mail.PostRegistry;
import forestry.mail.gui.ContainerMailbox;
import forestry.mail.gui.GuiMailbox;
import forestry.mail.tiles.IMailContainer;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class TileMailbox
extends TileBase
implements IMailContainer {
    private boolean isLinked = false;

    public TileMailbox() {
        super("mailbox");
        this.setInternalInventory(new InventoryAdapter(84, "Letters").disableAutomation());
    }

    @Override
    public void openGui(EntityPlayer player, ItemStack heldItem) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (PostManager.postRegistry.isLetter(heldItem)) {
            IPostalState result = this.tryDispatchLetter(heldItem);
            if (!result.isOk()) {
                player.func_145747_a((ITextComponent)new TextComponentString(result.getDescription()));
            } else {
                --heldItem.field_77994_a;
            }
        } else {
            super.openGui(player, heldItem);
        }
    }

    @Override
    public void updateServerSide() {
        if (!this.isLinked) {
            GameProfile owner = this.getAccessHandler().getOwner();
            if (owner != null) {
                this.getOrCreateMailInventory(this.field_145850_b, owner);
            }
            this.isLinked = true;
        }
    }

    public IInventory getOrCreateMailInventory(World world, @Nonnull GameProfile playerProfile) {
        if (world.field_72995_K) {
            return this.getInternalInventory();
        }
        IMailAddress address = PostManager.postRegistry.getMailAddress(playerProfile);
        return PostRegistry.getOrCreatePOBox(this.field_145850_b, address);
    }

    private IPostalState tryDispatchLetter(ItemStack letterStack) {
        ILetter letter = PostManager.postRegistry.getLetter(letterStack);
        IPostalState result = letter != null ? PostManager.postRegistry.getPostOffice(this.field_145850_b).lodgeLetter(this.field_145850_b, letterStack, true) : EnumDeliveryState.NOT_MAILABLE;
        return result;
    }

    @Override
    public boolean hasMail() {
        GameProfile owner = this.getAccessHandler().getOwner();
        if (owner == null) {
            return false;
        }
        IInventory mailInventory = this.getOrCreateMailInventory(this.field_145850_b, owner);
        for (int i = 0; i < mailInventory.func_70302_i_(); ++i) {
            if (mailInventory.func_70301_a(i) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiMailbox(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerMailbox(player.field_71071_by, this);
    }
}

