/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.entities;

import com.mojang.authlib.GameProfile;
import forestry.core.access.AccessHandler;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.gui.GuiHandler;
import forestry.core.gui.IGuiHandlerEntity;
import forestry.core.gui.IHintSource;
import forestry.core.tiles.ITitled;
import forestry.core.utils.Translator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class EntityMinecartForestry
extends EntityMinecart
implements ITitled,
IRestrictedAccess,
IHintSource,
IGuiHandlerEntity {
    private final AccessHandler accessHandler = new AccessHandler(this);

    public EntityMinecartForestry(World world) {
        super(world);
        this.func_94096_e(true);
    }

    public EntityMinecartForestry(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
        this.func_94096_e(true);
    }

    public boolean func_184230_a(EntityPlayer player, ItemStack stack, EnumHand hand) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player, stack, hand))) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            GuiHandler.openGui(player, this);
        }
        return true;
    }

    public void setOwner(GameProfile owner) {
        this.accessHandler.setOwner(owner);
    }

    public EntityMinecart.Type func_184264_v() {
        return null;
    }

    protected void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.accessHandler.readFromNBT(nbtTagCompound);
    }

    protected void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        this.accessHandler.writeToNBT(nbtTagCompound);
    }

    public boolean canBeRidden() {
        return false;
    }

    public boolean isPoweredCart() {
        return false;
    }

    public abstract IBlockState func_174897_t();

    public abstract ItemStack getCartItem();

    public void func_94095_a(DamageSource damageSource) {
        super.func_94095_a(damageSource);
        Block block = this.func_174897_t().func_177230_c();
        this.func_70099_a(new ItemStack(block, 1, block.func_176201_c(this.func_174897_t())), 0.0f);
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    public String func_70005_c_() {
        return Translator.translateToLocal(this.getUnlocalizedTitle());
    }

    @Override
    public String getUnlocalizedTitle() {
        ItemStack cartItem = this.getCartItem();
        return cartItem.func_77977_a() + ".name";
    }

    @Override
    public IAccessHandler getAccessHandler() {
        return this.accessHandler;
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
    }

    @Override
    public int getIdOfEntity() {
        return this.func_145782_y();
    }
}

