/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.arboriculture.worldgen.WorldGenArboriculture;
import forestry.core.worldgen.WorldGenBase;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class TileSapling
extends TileTreeContainer {
    private int timesTicked = 0;

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.timesTicked = nbttagcompound.func_74762_e("TT");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("TT", this.timesTicked);
        return nbttagcompound;
    }

    @Override
    public void onBlockTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        ++this.timesTicked;
        this.tryGrow(rand, false);
    }

    private static int getRequiredMaturity(World world, ITree tree) {
        ITreekeepingMode treekeepingMode = TreeManager.treeRoot.getTreekeepingMode(world);
        float maturationModifier = treekeepingMode.getMaturationModifier(tree.getGenome(), 1.0f);
        return Math.round((float)tree.getRequiredMaturity() * maturationModifier);
    }

    public boolean canAcceptBoneMeal(Random rand) {
        ITree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        int maturity = TileSapling.getRequiredMaturity(this.field_145850_b, tree);
        if (this.timesTicked < maturity) {
            return true;
        }
        WorldGenerator generator = tree.getTreeGenerator(this.field_145850_b, this.func_174877_v(), true);
        if (generator instanceof WorldGenArboriculture) {
            WorldGenArboriculture arboricultureGenerator = (WorldGenArboriculture)generator;
            arboricultureGenerator.preGenerate(this.field_145850_b, rand, this.func_174877_v());
            return arboricultureGenerator.getValidGrowthPos(this.field_145850_b, this.func_174877_v()) != null;
        }
        return true;
    }

    public void tryGrow(Random random, boolean bonemealed) {
        ITree tree = this.getTree();
        if (tree == null) {
            return;
        }
        int maturity = TileSapling.getRequiredMaturity(this.field_145850_b, tree);
        if (this.timesTicked < maturity) {
            if (bonemealed) {
                this.timesTicked = maturity;
            }
            return;
        }
        WorldGenerator generator = tree.getTreeGenerator(this.field_145850_b, this.func_174877_v(), bonemealed);
        boolean generated = generator instanceof WorldGenBase ? ((WorldGenBase)generator).generate(this.field_145850_b, random, this.func_174877_v(), false) : generator.func_180709_b(this.field_145850_b, random, this.func_174877_v());
        if (generated) {
            IArboristTracker breedingTracker = TreeManager.treeRoot.getBreedingTracker(this.field_145850_b, this.getOwner());
            breedingTracker.registerBirth(tree);
        }
    }
}

