/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import forestry.core.utils.Translator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class MutationConditionRequiresResource
implements IMutationCondition {
    private final Set<IBlockState> acceptedBlockStates = new HashSet<IBlockState>();
    private final String displayName;

    public MutationConditionRequiresResource(String oreDictName) {
        this.displayName = oreDictName;
        for (ItemStack ore : OreDictionary.getOres((String)oreDictName)) {
            Block oreBlock;
            Item oreItem;
            if (ore == null || (oreItem = ore.func_77973_b()) == null || (oreBlock = Block.func_149634_a((Item)oreItem)) == null) continue;
            this.acceptedBlockStates.addAll((Collection<IBlockState>)oreBlock.func_176194_O().func_177619_a());
        }
    }

    public MutationConditionRequiresResource(IBlockState ... acceptedBlockStates) {
        Collections.addAll(this.acceptedBlockStates, acceptedBlockStates);
        this.displayName = acceptedBlockStates[0].func_177230_c().func_149732_F();
    }

    @Override
    public float getChance(World world, BlockPos pos, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        TileEntity tile;
        while ((tile = world.func_175625_s(pos = pos.func_177977_b())) instanceof IBeeHousing) {
        }
        IBlockState blockState = world.func_180495_p(pos);
        return this.acceptedBlockStates.contains(blockState) ? 1.0f : 0.0f;
    }

    @Override
    public String getDescription() {
        return Translator.translateToLocalFormatted("for.mutation.condition.resource", this.displayName);
    }
}

