/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.factory.gui.ContainerBottler;
import forestry.factory.gui.GuiBottler;
import forestry.factory.inventory.InventoryBottler;
import forestry.factory.recipes.BottlerRecipe;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileBottler
extends TilePowered
implements ISidedInventory,
ILiquidTankTile {
    private static final int TICKS_PER_RECIPE_TIME = 5;
    private static final int ENERGY_PER_RECIPE_TIME = 1000;
    private final StandardTank resourceTank;
    private final TankManager tankManager;
    private BottlerRecipe currentRecipe;

    public TileBottler() {
        super("bottler", 1100, 4000);
        this.setInternalInventory(new InventoryBottler(this));
        this.resourceTank = new StandardTank(10000);
        this.tankManager = new TankManager(this, this.resourceTank);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        this.checkRecipe();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 2);
        }
    }

    @Override
    public boolean workCycle() {
        FluidHelper.FillStatus status = FluidHelper.fillContainers(this.tankManager, (IInventory)this, 0, 1, this.currentRecipe.input.getFluid(), true);
        return status == FluidHelper.FillStatus.SUCCESS;
    }

    private void checkRecipe() {
        ItemStack emptyCan = this.func_70301_a(0);
        FluidStack resource = this.resourceTank.getFluid();
        if (resource == null) {
            return;
        }
        if (this.currentRecipe == null || !this.currentRecipe.matches(emptyCan, resource)) {
            this.currentRecipe = BottlerRecipe.create(resource.getFluid(), emptyCan);
            if (this.currentRecipe != null) {
                float viscosityMultiplier = (float)resource.getFluid().getViscosity(resource) / 1000.0f;
                viscosityMultiplier = (viscosityMultiplier - 1.0f) / 20.0f + 1.0f;
                int fillAmount = Math.min(this.currentRecipe.input.amount, resource.amount);
                float fillTime = (float)fillAmount / 1000.0f;
                this.setTicksPerWorkCycle(Math.round((fillTime *= viscosityMultiplier) * 5.0f));
                this.setEnergyPerWorkCycle(Math.round(fillTime * 1000.0f));
            }
        }
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(0) == null) {
            return false;
        }
        return (float)inventory.func_70301_a((int)0).field_77994_a / (float)inventory.func_70301_a(0).func_77976_d() > percentage;
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        IErrorLogic errorLogic = this.getErrorLogic();
        FluidHelper.FillStatus status = this.currentRecipe == null ? FluidHelper.FillStatus.NO_FLUID : FluidHelper.fillContainers(this.tankManager, (IInventory)this, 0, 1, this.currentRecipe.input.getFluid(), false);
        errorLogic.setCondition(status == FluidHelper.FillStatus.NO_FLUID, EnumErrorCode.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(status == FluidHelper.FillStatus.NO_SPACE, EnumErrorCode.NO_SPACE_INVENTORY);
        return status == FluidHelper.FillStatus.SUCCESS;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    @Nonnull
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return super.getCapability(capability, facing);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankManager);
        }
        return null;
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiBottler(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerBottler(player.field_71071_by, this);
    }
}

