/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.tiles;

import forestry.api.core.IErrorLogic;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.ITankManager;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.IRenderableTile;
import forestry.core.tiles.TileBase;
import forestry.energy.gui.ContainerGenerator;
import forestry.energy.gui.GuiGenerator;
import forestry.energy.inventory.InventoryGenerator;
import forestry.plugins.compat.PluginIC2;
import ic2.api.energy.prefab.BasicSource;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEuGenerator
extends TileBase
implements ISidedInventory,
ILiquidTankTile,
IRenderableTile {
    private static final int maxEnergy = 30000;
    private final TankManager tankManager;
    private final FilteredTank resourceTank;
    private int tickCount = 0;
    private BasicSource ic2EnergySource;

    public TileEuGenerator() {
        super("generator");
        this.setInternalInventory(new InventoryGenerator(this));
        this.resourceTank = new FilteredTank(10000);
        this.resourceTank.setFilters(FuelManager.generatorFuel.keySet());
        this.tankManager = new TankManager(this, this.resourceTank);
        if (PluginIC2.instance.isAvailable()) {
            this.ic2EnergySource = new BasicSource((TileEntity)this, 30000.0, 1);
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        if (this.ic2EnergySource != null) {
            this.ic2EnergySource.func_189515_b(nbttagcompound);
        }
        this.tankManager.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (this.ic2EnergySource != null) {
            this.ic2EnergySource.func_145839_a(nbttagcompound);
        }
        this.tankManager.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    public void onChunkUnload() {
        if (this.ic2EnergySource != null) {
            this.ic2EnergySource.onChunkUnload();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        if (this.ic2EnergySource != null) {
            this.ic2EnergySource.func_145843_s();
        }
        super.func_145843_s();
    }

    @Override
    public void updateServerSide() {
        IErrorLogic errorLogic;
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 0);
        }
        if ((errorLogic = this.getErrorLogic()).setCondition(this.ic2EnergySource == null, EnumErrorCode.NO_ENERGY_NET)) {
            return;
        }
        this.ic2EnergySource.func_73660_a();
        if (this.resourceTank.getFluidAmount() > 0) {
            GeneratorFuel fuel = FuelManager.generatorFuel.get(this.resourceTank.getFluid().getFluid());
            if (this.resourceTank.canDrainFluidType(fuel.fuelConsumed) && this.ic2EnergySource.getFreeCapacity() >= (double)fuel.eu) {
                this.ic2EnergySource.addEnergy((double)fuel.eu);
                ++this.tickCount;
                if (this.tickCount >= fuel.rate) {
                    this.tickCount = 0;
                    this.resourceTank.drain(fuel.fuelConsumed.amount, true);
                }
            }
        }
        boolean hasFuel = this.resourceTank.getFluidAmount() > 0;
        errorLogic.setCondition(!hasFuel, EnumErrorCode.NO_FUEL);
    }

    public boolean isWorking() {
        return this.resourceTank.getFluidAmount() > 0;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    public int getStoredScaled(int i) {
        if (this.ic2EnergySource == null) {
            return 0;
        }
        return (int)(this.ic2EnergySource.getEnergyStored() * (double)i) / 30000;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return TankRenderInfo.EMPTY;
    }

    public void getGUINetworkData(int i, int j) {
        if (i == 0 && this.ic2EnergySource != null) {
            this.ic2EnergySource.setEnergyStored((double)j);
        }
    }

    public void sendGUINetworkData(Container container, IContainerListener iCrafting) {
        if (this.ic2EnergySource != null) {
            iCrafting.func_71112_a(container, 0, (int)((short)this.ic2EnergySource.getEnergyStored()));
        }
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiGenerator(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerGenerator(player.field_71071_by, this);
    }

    @Override
    @Nonnull
    public ITankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return super.getCapability(capability, facing);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankManager);
        }
        return null;
    }
}

