/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui;

import com.google.common.base.Predicate;
import com.google.common.primitives.Floats;
import forestry.api.climate.IClimateControl;
import forestry.api.core.ICamouflageHandler;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.ledgers.ClimateLedger;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.gui.widgets.WidgetCamouflageSlot;
import forestry.core.network.packets.PacketUpdateClimateControl;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.Translator;
import forestry.greenhouse.gui.ContainerGreenhouse;
import forestry.greenhouse.multiblock.DefaultClimateControl;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouse;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;

public class GuiGreenhouse
extends GuiForestryTitled<ContainerGreenhouse, TileGreenhouse> {
    private static final Predicate<String> numberFilter = new Predicate<String>(){

        public boolean apply(@Nullable String text) {
            if (!text.isEmpty() && text.length() > 1 && !text.contains(".")) {
                return false;
            }
            if (text.length() > 7) {
                return false;
            }
            Float f = Floats.tryParse((String)text);
            return text.isEmpty() || f != null && Floats.isFinite((float)f.floatValue()) && f.floatValue() >= 0.0f;
        }
    };
    private GuiTextField humidityField;
    private GuiTextField temperatureField;
    private boolean fieldsEnabeled;

    public GuiGreenhouse(EntityPlayer player, TileGreenhouse tile) {
        super("textures/gui/greenhouse.png", new ContainerGreenhouse(player.field_71071_by, tile), tile);
        this.widgetManager.add(new TankWidget(this.widgetManager, 152, 16, 0).setOverlayOrigin(176, 0));
        this.widgetManager.add(new WidgetCamouflageSlot(this.widgetManager, 8, 16, ((MultiblockLogicGreenhouse)((TileGreenhouse)this.inventory).getMultiblockLogic()).getController(), "default"));
        this.widgetManager.add(new WidgetCamouflageSlot(this.widgetManager, 8, 37, ((MultiblockLogicGreenhouse)((TileGreenhouse)this.inventory).getMultiblockLogic()).getController(), "glass"));
        this.widgetManager.add(new WidgetCamouflageSlot(this.widgetManager, 8, 58, ((MultiblockLogicGreenhouse)((TileGreenhouse)this.inventory).getMultiblockLogic()).getController(), "door"));
        this.widgetManager.add(new WidgetCamouflageSlot(this.widgetManager, 35, 37, (ICamouflageHandler)this.inventory, tile.getCamouflageType()));
        this.fieldsEnabeled = true;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.temperatureField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 63, this.field_147009_r + 30, 50, 10);
        this.humidityField = new GuiTextField(1, this.field_146289_q, this.field_147003_i + 63, this.field_147009_r + 60, 50, 10);
        this.temperatureField.func_175205_a(numberFilter);
        this.humidityField.func_175205_a(numberFilter);
        IGreenhouseControllerInternal controller = ((MultiblockLogicGreenhouse)((TileGreenhouse)this.inventory).getMultiblockLogic()).getController();
        if (controller == null || controller.getClimateControl() == null || controller.getClimateControl() == DefaultClimateControl.instance) {
            this.temperatureField.func_146184_c(false);
            this.temperatureField.func_146189_e(false);
            this.humidityField.func_146184_c(false);
            this.humidityField.func_146189_e(false);
            this.fieldsEnabeled = false;
        } else {
            IClimateControl control = controller.getClimateControl();
            this.temperatureField.func_146180_a(Float.toString(control.getControlTemperature()));
            this.humidityField.func_146180_a(Float.toString(control.getControlHumidity()));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.fieldsEnabeled) {
            if (!this.humidityField.func_146201_a(typedChar, keyCode) && !this.temperatureField.func_146201_a(typedChar, keyCode)) {
                super.func_73869_a(typedChar, keyCode);
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.fieldsEnabeled) {
            boolean temperatureWasFocused = this.temperatureField.func_146206_l();
            boolean humidityWasFocused = this.humidityField.func_146206_l();
            this.temperatureField.func_146192_a(mouseX, mouseY, mouseButton);
            this.humidityField.func_146192_a(mouseX, mouseY, mouseButton);
            IGreenhouseControllerInternal provider = ((MultiblockLogicGreenhouse)((TileGreenhouse)this.inventory).getMultiblockLogic()).getController();
            IClimateControl control = provider.getClimateControl();
            if (temperatureWasFocused && !this.temperatureField.func_146206_l()) {
                float temp = this.parseField(this.temperatureField);
                this.temperatureField.func_146180_a(Float.toString(temp));
                control.setControlTemperature(temp);
            } else if (humidityWasFocused && !this.humidityField.func_146206_l()) {
                float hum = this.parseField(this.humidityField);
                this.humidityField.func_146180_a(Float.toString(hum));
                control.setControlHumidity(this.parseField(this.humidityField));
            }
            Proxies.net.sendToServer(new PacketUpdateClimateControl(provider));
        }
    }

    private float parseField(GuiTextField field) {
        String text = field.func_146179_b();
        if (text.isEmpty()) {
            return 2.0f;
        }
        try {
            float f = Float.parseFloat(text);
            if (f >= 2.0f) {
                f = 2.0f;
            }
            return f;
        }
        catch (NumberFormatException var5) {
            return 2.0f;
        }
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        if (this.temperatureField.func_146176_q()) {
            this.textLayout.line = 20;
            this.textLayout.drawCenteredLine(Translator.translateToLocal("for.gui.temperature"), 0, this.fontColor.get("gui.greenhouse.temperature.text"));
            this.temperatureField.func_146194_f();
        }
        if (this.humidityField.func_146176_q()) {
            this.textLayout.line = 50;
            this.textLayout.drawCenteredLine(Translator.translateToLocal("for.gui.humidity"), 0, this.fontColor.get("gui.greenhouse.humidity.text"));
            this.humidityField.func_146194_f();
        }
        this.bindTexture(this.textureFile);
    }

    @Override
    protected void addLedgers() {
        IGreenhouseControllerInternal greenhouseController = ((MultiblockLogicGreenhouse)((TileGreenhouse)this.inventory).getMultiblockLogic()).getController();
        this.ledgerManager.add(new ClimateLedger(this.ledgerManager, greenhouseController));
        this.ledgerManager.add(new EnergyLedger());
        super.addLedgers();
    }

    protected class EnergyLedger
    extends Ledger {
        public EnergyLedger() {
            super(GuiGreenhouse.this.ledgerManager, "power");
            this.maxHeight = 48;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawSprite(TextureManager.getInstance().getDefault("misc/energy"), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            this.drawHeader(Translator.translateToLocal("for.gui.energy"), x + 22, y + 8);
            this.drawSubheader(Translator.translateToLocal("for.gui.stored") + ':', x + 22, y + 20);
            this.drawText(((MultiblockLogicGreenhouse)((TileGreenhouse)GuiGreenhouse.this.inventory).getMultiblockLogic()).getController().getEnergyManager().getEnergyStored(null) + " RF", x + 22, y + 32);
        }

        @Override
        public String getTooltip() {
            return Translator.translateToLocal("for.gui.energy") + ": " + ((MultiblockLogicGreenhouse)((TileGreenhouse)GuiGreenhouse.this.inventory).getMultiblockLogic()).getController().getEnergyManager().getEnergyStored(null) + " RF/t";
        }
    }
}

