/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import forestry.api.climate.IClimateSource;
import forestry.api.climate.IClimatiserDefinition;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.apiculture.network.packets.PacketActiveUpdate;
import forestry.core.climate.ClimateSource;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IActivatable;
import forestry.greenhouse.GreenhouseClimateSource;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouse;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileGreenhouseClimatiser
extends TileGreenhouse
implements IActivatable,
IGreenhouseComponent.Climatiser {
    protected static final int WORK_CYCLES = 1;
    protected static final int ENERGY_PER_OPERATION = 150;
    private final IClimatiserDefinition definition;
    private final ClimateSource source;
    protected EnumFacing inwards;
    protected EnumFacing leftwards;
    protected BlockPos maxPos;
    protected BlockPos minPos;
    private boolean active;

    protected TileGreenhouseClimatiser(IClimatiserDefinition definition, int ticksForChange) {
        this(definition, new GreenhouseClimateSource(ticksForChange));
    }

    protected TileGreenhouseClimatiser(IClimatiserDefinition definition, ClimateSource source) {
        this.definition = definition;
        this.source = source;
        this.source.setProvider(this);
    }

    protected TileGreenhouseClimatiser(IClimatiserDefinition definition) {
        this(definition, 26);
    }

    @Override
    public void onMachineBroken() {
        this.inwards = null;
        this.leftwards = null;
        this.minPos = null;
        this.maxPos = null;
    }

    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
        this.recalculateDirections(minCoord, maxCoord);
        int range = Math.round((float)this.definition.getRange() / 2.0f);
        if (this.leftwards != null) {
            this.maxPos = this.getCoordinates().func_177967_a(this.inwards, range).func_177967_a(this.leftwards, range).func_177967_a(EnumFacing.UP, range);
            this.minPos = this.getCoordinates().func_177972_a(this.inwards).func_177967_a(this.leftwards.func_176734_d(), range).func_177967_a(EnumFacing.DOWN, range);
        } else {
            this.maxPos = this.getCoordinates().func_177967_a(this.inwards, range).func_177967_a(EnumFacing.EAST, range).func_177967_a(EnumFacing.NORTH, range);
            this.minPos = this.getCoordinates().func_177972_a(this.inwards).func_177967_a(EnumFacing.WEST, range).func_177967_a(EnumFacing.SOUTH, range);
        }
    }

    public BlockPos getMinPos() {
        return this.minPos;
    }

    public BlockPos getMaxPos() {
        return this.maxPos;
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.func_74757_a("Active", this.active);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        this.setActive(packetData.func_74767_n("Active"));
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void recalculateDirections(BlockPos minCoord, BlockPos maxCoord) {
        this.inwards = null;
        this.leftwards = null;
        int facesMatching = 0;
        if (maxCoord.func_177958_n() == this.getCoordinates().func_177958_n() || minCoord.func_177958_n() == this.getCoordinates().func_177958_n()) {
            ++facesMatching;
        }
        if (maxCoord.func_177956_o() == this.getCoordinates().func_177956_o() || minCoord.func_177956_o() == this.getCoordinates().func_177956_o()) {
            ++facesMatching;
        }
        if (maxCoord.func_177952_p() == this.getCoordinates().func_177952_p() || minCoord.func_177952_p() == this.getCoordinates().func_177952_p()) {
            ++facesMatching;
        }
        if (facesMatching == 1) {
            if (maxCoord.func_177958_n() == this.getCoordinates().func_177958_n()) {
                this.inwards = EnumFacing.WEST;
                this.leftwards = EnumFacing.SOUTH;
            } else if (minCoord.func_177958_n() == this.getCoordinates().func_177958_n()) {
                this.inwards = EnumFacing.EAST;
                this.leftwards = EnumFacing.NORTH;
            } else if (maxCoord.func_177952_p() == this.getCoordinates().func_177952_p()) {
                this.inwards = EnumFacing.NORTH;
                this.leftwards = EnumFacing.WEST;
            } else if (minCoord.func_177952_p() == this.getCoordinates().func_177952_p()) {
                this.inwards = EnumFacing.SOUTH;
                this.leftwards = EnumFacing.EAST;
            } else {
                this.inwards = maxCoord.func_177956_o() == this.getCoordinates().func_177956_o() ? EnumFacing.DOWN : EnumFacing.UP;
            }
        } else {
            this.inwards = EnumFacing.DOWN;
        }
    }

    @Override
    public IClimatiserDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public IClimateSource getClimateSource() {
        return this.source;
    }

    public boolean canWork() {
        Object logic = this.getMultiblockLogic();
        if (logic == null || !logic.isConnected() || ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getEnergyManager() == null) {
            return false;
        }
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getEnergyManager().consumeEnergyToDoWork(1, 150);
    }

    public Iterable<BlockPos> getPositionsInRange() {
        if (this.maxPos == null || this.minPos == null) {
            return null;
        }
        return BlockPos.func_177980_a((BlockPos)this.maxPos, (BlockPos)this.minPos);
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175704_b(this.getCoordinates(), this.getCoordinates());
            } else {
                Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this), this.field_145850_b);
            }
        }
    }
}

