/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui;

import forestry.api.core.ICamouflageHandler;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.ledgers.ClimateLedger;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.render.TextureManager;
import forestry.core.utils.Translator;
import forestry.greenhouse.gui.ContainerGreenhouse;
import forestry.greenhouse.gui.widgets.WidgetCamouflageSlot;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouse;
import net.minecraft.entity.player.EntityPlayer;

public class GuiGreenhouse
extends GuiForestryTitled<ContainerGreenhouse, TileGreenhouse> {
    public GuiGreenhouse(EntityPlayer player, TileGreenhouse tile) {
        super("textures/gui/greenhouse.png", new ContainerGreenhouse(player.field_71071_by, tile), tile);
        this.widgetManager.add(new TankWidget(this.widgetManager, 152, 16, 0).setOverlayOrigin(176, 0));
        this.widgetManager.add(new WidgetCamouflageSlot(this.widgetManager, 8, 16, ((MultiblockLogicGreenhouse)((TileGreenhouse)this.inventory).getMultiblockLogic()).getController(), "default"));
        this.widgetManager.add(new WidgetCamouflageSlot(this.widgetManager, 8, 37, ((MultiblockLogicGreenhouse)((TileGreenhouse)this.inventory).getMultiblockLogic()).getController(), "glass"));
        this.widgetManager.add(new WidgetCamouflageSlot(this.widgetManager, 8, 58, ((MultiblockLogicGreenhouse)((TileGreenhouse)this.inventory).getMultiblockLogic()).getController(), "door"));
        this.widgetManager.add(new WidgetCamouflageSlot(this.widgetManager, 35, 37, (ICamouflageHandler)this.inventory, tile.getCamouflageType()));
    }

    @Override
    protected void addLedgers() {
        IGreenhouseControllerInternal greenhouseController = ((MultiblockLogicGreenhouse)((TileGreenhouse)this.inventory).getMultiblockLogic()).getController();
        this.ledgerManager.add(new ClimateLedger(this.ledgerManager, greenhouseController));
        this.ledgerManager.add(new EnergyLedger());
        super.addLedgers();
    }

    protected class EnergyLedger
    extends Ledger {
        public EnergyLedger() {
            super(GuiGreenhouse.this.ledgerManager, "power");
            this.maxHeight = 48;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawSprite(TextureManager.getInstance().getDefault("misc/energy"), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            this.drawHeader(Translator.translateToLocal("for.gui.energy"), x + 22, y + 8);
            this.drawSubheader(Translator.translateToLocal("for.gui.stored") + ':', x + 22, y + 20);
            this.drawText(((MultiblockLogicGreenhouse)((TileGreenhouse)GuiGreenhouse.this.inventory).getMultiblockLogic()).getController().getEnergyManager().getEnergyStored(null) + " RF", x + 22, y + 32);
        }

        @Override
        public String getTooltip() {
            return Translator.translateToLocal("for.gui.energy") + ": " + ((MultiblockLogicGreenhouse)((TileGreenhouse)GuiGreenhouse.this.inventory).getMultiblockLogic()).getController().getEnergyManager().getEnergyStored(null) + " RF/t";
        }
    }
}

