/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.core.ForestryAPI;
import forestry.api.core.climate.IClimateRegion;
import forestry.api.core.climate.IClimateSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClimateEventHandler {
    Map<Integer, Integer> serverTicks = new HashMap<Integer, Integer>();

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        Integer dim = event.world.field_73011_w.getDimension();
        if (event.phase == TickEvent.Phase.END) {
            Map<Integer, Map<BlockPos, IClimateSource>> sources;
            if (!this.serverTicks.containsKey(dim)) {
                this.serverTicks.put(dim, 1);
            }
            int ticks = this.serverTicks.get(dim);
            Map<Integer, List<IClimateRegion>> regions = ForestryAPI.climateManager.getRegions();
            if (regions != null && regions.containsKey(dim)) {
                for (IClimateRegion region : regions.get(dim)) {
                    if (ticks % region.getTicksPerUpdate() != 0) continue;
                    region.updateClimate();
                }
            }
            if ((sources = ForestryAPI.climateManager.getSources()) != null && sources.containsKey(dim)) {
                for (IClimateSource source : sources.get(dim).values()) {
                    IClimateRegion region = ForestryAPI.climateManager.getRegionForPos(event.world, source.getPos());
                    if (region == null || ticks % source.getTicksForChange(region) != 0) continue;
                    source.changeClimate(ticks, region);
                }
            }
            this.serverTicks.put(dim, ticks + 1);
        }
    }
}

