/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class CamouflageUtil {
    public static void writeCamouflageBlockToNBT(NBTTagCompound data, ICamouflageHandler handler, String type) {
        ItemStack camouflageBlock = handler.getCamouflageBlock(type);
        if (camouflageBlock != null) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            camouflageBlock.func_77955_b(nbtTag);
            data.func_74782_a("Camouflage" + type, (NBTBase)nbtTag);
        }
    }

    public static void readCamouflageBlockFromNBT(NBTTagCompound data, ICamouflageHandler handler, String type) {
        if (data.func_74764_b("Camouflage" + type)) {
            handler.setCamouflageBlock(type, ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("Camouflage" + type)));
        }
    }

    public static void writeCamouflageBlockToData(DataOutputStreamForestry data, ICamouflageHandler handler, String type) throws IOException {
        ItemStack camouflageBlock = handler.getCamouflageBlock(type);
        if (camouflageBlock != null) {
            data.writeShort(1);
            data.writeUTF(type);
            data.writeItemStack(camouflageBlock);
        } else {
            data.writeShort(0);
        }
    }

    public static void readCamouflageBlockFromData(DataInputStreamForestry data, ICamouflageHandler handler) throws IOException {
        if (data.readShort() == 1) {
            handler.setCamouflageBlock(data.readUTF(), data.readItemStack());
        }
    }

    public static ICamouflageHandler getCamouflageHandler(IBlockAccess world, BlockPos pos) {
        if (pos == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ICamouflagedTile) {
            IMultiblockComponent component;
            ICamouflagedTile block = (ICamouflagedTile)tile;
            String type = block.getCamouflageType();
            ItemStack camouflageStack = null;
            ICamouflageHandler handler = null;
            if (tile instanceof ICamouflageHandler) {
                handler = (ICamouflageHandler)tile;
                camouflageStack = handler.getCamouflageBlock(type);
            }
            if (camouflageStack == null && tile instanceof IMultiblockComponent && (component = (IMultiblockComponent)tile).getMultiblockLogic().getController() instanceof ICamouflageHandler) {
                handler = (ICamouflageHandler)((Object)component.getMultiblockLogic().getController());
            }
            return handler;
        }
        return null;
    }

    public static ItemStack getCamouflageBlock(IBlockAccess world, BlockPos pos) {
        if (pos == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ICamouflagedTile) {
            ICamouflageHandler handler;
            IMultiblockComponent component;
            ICamouflagedTile block = (ICamouflagedTile)tile;
            String type = block.getCamouflageType();
            ItemStack camouflageStack = null;
            if (tile instanceof ICamouflageHandler) {
                ICamouflageHandler handler2 = (ICamouflageHandler)tile;
                camouflageStack = handler2.getCamouflageBlock(type);
            }
            if (camouflageStack == null && tile instanceof IMultiblockComponent && (component = (IMultiblockComponent)tile).getMultiblockLogic().getController() instanceof ICamouflageHandler && (camouflageStack = (handler = (ICamouflageHandler)((Object)component.getMultiblockLogic().getController())).getCamouflageBlock(type)) == null) {
                camouflageStack = handler.getDefaultCamouflageBlock(type);
            }
            return camouflageStack;
        }
        return null;
    }
}

