/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.core.climate.IClimatePosition;
import forestry.api.core.climate.IClimateRegion;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;

public class ClimatePosition
implements IClimatePosition {
    @Nonnull
    protected final IClimateRegion climateRegion;
    @Nonnull
    protected final BlockPos pos;
    protected float temperature;
    protected float humidity;

    public ClimatePosition(IClimateRegion climateRegion, BlockPos pos) {
        Biome biome = climateRegion.getWorld().func_180494_b(pos);
        this.climateRegion = climateRegion;
        this.pos = pos;
        this.temperature = biome.func_185353_n();
        this.humidity = biome.func_76727_i();
    }

    public ClimatePosition(@Nonnull IClimateRegion climateRegion, @Nonnull BlockPos pos, float temperature, float humidity) {
        this.climateRegion = climateRegion;
        this.pos = pos;
        this.temperature = temperature;
        this.humidity = humidity;
    }

    @Override
    @Nonnull
    public IClimateRegion getClimateRegion() {
        return this.climateRegion;
    }

    @Override
    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public void addTemperature(float temperature) {
        this.setTemperature(this.getTemperature() + temperature);
    }

    @Override
    public void addHumidity(float humidity) {
        this.setHumidity(this.getHumidity() + humidity);
    }

    @Override
    public void setHumidity(float humidity) {
        this.humidity = humidity;
    }

    @Override
    public float getHumidity() {
        return this.humidity;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.temperature = nbt.func_74760_g("Temperature");
        this.humidity = nbt.func_74760_g("Humidity");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("Temperature", this.temperature);
        nbt.func_74776_a("Humidity", this.humidity);
        return nbt;
    }
}

