/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forestry.Forestry;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IAlleleButterflyCocoon;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.core.PluginCore;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.lepidopterology.ButterflySpawner;
import forestry.lepidopterology.blocks.BlockRegistryLepidopterology;
import forestry.lepidopterology.commands.CommandButterfly;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.genetics.ButterflyBranchDefinition;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import forestry.lepidopterology.genetics.ButterflyFactory;
import forestry.lepidopterology.genetics.ButterflyMutationFactory;
import forestry.lepidopterology.genetics.ButterflyRoot;
import forestry.lepidopterology.genetics.MothDefinition;
import forestry.lepidopterology.genetics.alleles.AlleleButterflyCocoon;
import forestry.lepidopterology.genetics.alleles.AlleleButterflyEffect;
import forestry.lepidopterology.items.ItemRegistryLepidopterology;
import forestry.lepidopterology.proxy.ProxyLepidopterology;
import forestry.lepidopterology.recipes.MatingRecipe;
import forestry.lepidopterology.tiles.TileCocoon;
import forestry.lepidopterology.worldgen.CocoonDecorator;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;

@ForestryPlugin(pluginID="forestry.lepidopterology", name="Lepidopterology", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.lepidopterology.description")
public class PluginLepidopterology
extends BlankForestryPlugin {
    @SidedProxy(clientSide="forestry.lepidopterology.proxy.ProxyLepidopterologyClient", serverSide="forestry.lepidopterology.proxy.ProxyLepidopterology")
    public static ProxyLepidopterology proxy;
    private static final String CONFIG_CATEGORY = "lepidopterology";
    public static int spawnConstraint;
    public static int entityConstraint;
    private static boolean allowPollination;
    public static final Map<String, Float> spawnRaritys;
    private static boolean spawnButterflysFromLeaves;
    private static boolean generateCocoons;
    private static float generateCocoonsAmount;
    private static float serumChance;
    private static float secondSerumChance;
    public static ItemRegistryLepidopterology items;
    public static BlockRegistryLepidopterology blocks;

    @Override
    public void setupAPI() {
        ButterflyManager.butterflyRoot = new ButterflyRoot();
        AlleleManager.alleleRegistry.registerSpeciesRoot(ButterflyManager.butterflyRoot);
        ButterflyManager.butterflyFactory = new ButterflyFactory();
        ButterflyManager.butterflyMutationFactory = new ButterflyMutationFactory();
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryLepidopterology();
        blocks = new BlockRegistryLepidopterology();
    }

    @Override
    public void preInit() {
        ButterflyBranchDefinition.createAlleles();
        AlleleButterflyEffect.createAlleles();
        GameRegistry.registerTileEntity(TileCocoon.class, (String)"forestry.Cocoon");
        proxy.preInitializeRendering();
    }

    @Override
    @Nonnull
    public Set<String> getDependencyUids() {
        Set<String> dependencyUids = super.getDependencyUids();
        dependencyUids.add("forestry.arboriculture");
        return dependencyUids;
    }

    @Override
    public void doInit() {
        PluginCore.rootCommand.addChildCommand(new CommandButterfly());
        EntityUtil.registerEntity(EntityButterfly.class, "butterflyGE", 0, 0, 0xFFFFFF, 50, 1, true);
        MothDefinition.initMoths();
        ButterflyDefinition.initButterflies();
        AlleleButterflyCocoon.createLoot();
        PluginLepidopterology.blocks.butterflyChest.init();
        if (spawnButterflysFromLeaves) {
            TreeManager.treeRoot.registerLeafTickHandler(new ButterflySpawner());
        }
        RecipeSorter.register((String)"forestry:lepidopterologymating", MatingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:minecraft:shapeless");
    }

    @Override
    public void postInit() {
        File configFile = new File(Forestry.instance.getConfigFolder(), "lepidopterology.cfg");
        PluginLepidopterology.loadConfig(configFile);
    }

    @Override
    public void populateChunk(IChunkGenerator chunkGenerator, World world, Random rand, int chunkX, int chunkZ, boolean hasVillageGenerated) {
        if (generateCocoons && (double)generateCocoonsAmount > 0.0) {
            CocoonDecorator.decorateCocoons(chunkGenerator, world, rand, chunkX, chunkZ, hasVillageGenerated);
        }
    }

    @Override
    public void populateChunkRetroGen(World world, Random rand, int chunkX, int chunkZ) {
        if (generateCocoons && (double)generateCocoonsAmount > 0.0) {
            CocoonDecorator.decorateCocoons(world, rand, chunkX, chunkZ);
        }
    }

    private static void loadConfig(File configFile) {
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "1.1.0");
        spawnConstraint = config.getIntLocalized("butterfly.entities", "spawn.limit", spawnConstraint, 0, 500);
        entityConstraint = config.getIntLocalized("butterfly.entities", "maximum", entityConstraint, 0, 5000);
        allowPollination = config.getBooleanLocalized("butterfly.entities", "pollination", allowPollination);
        spawnButterflysFromLeaves = config.getBooleanLocalized("butterfly.entities", "spawn.leaves", spawnButterflysFromLeaves);
        generateCocoons = config.getBooleanLocalized("butterfly.cocoons", "generate", generateCocoons);
        generateCocoonsAmount = config.getFloatLocalized("butterfly.cocoons", "generate.amount", generateCocoonsAmount, 0.0f, 10.0f);
        serumChance = config.getFloatLocalized("butterfly.cocoons", "serum", serumChance, 0.0f, 100.0f);
        secondSerumChance = config.getFloatLocalized("butterfly.cocoons", "second.serum", secondSerumChance, 0.0f, 100.0f);
        PluginLepidopterology.parseRarity(config);
        PluginLepidopterology.parseCooconLoots(config);
        config.save();
    }

    private static void parseRarity(LocalizedConfiguration config) {
        String[] configRaritys;
        ArrayList butterflyRarity = Lists.newArrayList();
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleButterflySpecies)) continue;
            IAlleleButterflySpecies species = (IAlleleButterflySpecies)allele;
            butterflyRarity.add(species.getUID() + ":" + species.getRarity());
        }
        Collections.sort(butterflyRarity);
        String[] defaultRaritys = butterflyRarity.toArray(new String[butterflyRarity.size()]);
        Property rarityConf = config.get("butterfly.alleles", "rarity", defaultRaritys);
        rarityConf.setComment(Translator.translateToLocal("for.config.butterfly.alleles.rarity"));
        for (String rarity : configRaritys = rarityConf.getStringList()) {
            if (!rarity.contains(":") || rarity.length() <= 3) continue;
            String[] raritys = rarity.split(":");
            try {
                spawnRaritys.put(raritys[0], Float.valueOf(Float.parseFloat(raritys[1])));
            }
            catch (Exception e) {
                Log.error("Failed to parse spawn rarity for butterfly. {}", rarity, e);
            }
        }
    }

    private static void parseCooconLoots(LocalizedConfiguration config) {
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleButterflyCocoon)) continue;
            PluginLepidopterology.parseCooconLoot(config, (IAlleleButterflyCocoon)allele);
        }
    }

    private static void parseCooconLoot(LocalizedConfiguration config, IAlleleButterflyCocoon cocoon) {
        String[] configLoot;
        HashMap<ItemStack, Float> cooconLoot = new HashMap<ItemStack, Float>();
        ArrayList<String> lootList = new ArrayList<String>();
        for (Map.Entry<ItemStack, Float> entry : cocoon.getCocoonLoot().entrySet()) {
            String itemStackString = ItemStackUtil.getItemNameFromRegistryAsString(entry.getKey().func_77973_b());
            int meta = entry.getKey().func_77952_i();
            if (meta != Short.MAX_VALUE) {
                itemStackString = itemStackString + ':' + meta;
            }
            lootList.add(itemStackString + ";" + entry.getValue());
        }
        Collections.sort(lootList);
        String[] defaultLoot = lootList.toArray(new String[lootList.size()]);
        Property lootConf = config.get("butterfly.cocoons.alleles.loot", cocoon.getUID(), defaultLoot);
        lootConf.setComment(Translator.translateToLocal("for.config.butterfly.alleles.loot"));
        for (String loot : configLoot = lootConf.getStringList()) {
            if (!loot.contains(";") || loot.length() <= 3) continue;
            String[] loots = loot.split(";");
            try {
                ItemStack itemStack = ItemStackUtil.parseItemStackString(loots[0], Short.MAX_VALUE);
                if (itemStack == null) continue;
                cooconLoot.put(itemStack, Float.valueOf(Float.parseFloat(loots[1])));
            }
            catch (Exception e) {
                Log.error("Failed to parse cocoon loot. {}", loot, e);
            }
        }
        cocoon.getCocoonLoot().clear();
        cocoon.getCocoonLoot().putAll(cooconLoot);
    }

    @Override
    public void registerRecipes() {
        CraftingManager.func_77594_a().func_77592_b().add(new MatingRecipe());
        RecipeUtil.addRecipe(PluginLepidopterology.blocks.butterflyChest, " # ", "XYX", "XXX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), new ItemStack((Item)PluginLepidopterology.items.butterflyGE, 1, Short.MAX_VALUE), Character.valueOf('Y'), "chestWood");
    }

    @Override
    public void getHiddenItems(List<ItemStack> hiddenItems) {
        hiddenItems.add(new ItemStack((Block)PluginLepidopterology.blocks.cocoon));
        hiddenItems.add(new ItemStack((Block)PluginLepidopterology.blocks.solidCocoon));
    }

    public static boolean isPollinationAllowed() {
        return allowPollination;
    }

    public static boolean isSpawnButterflysFromLeaves() {
        return spawnButterflysFromLeaves;
    }

    public static boolean isGenerateCocoons() {
        return generateCocoons;
    }

    public static float getGenerateCocoonsAmount() {
        return generateCocoonsAmount;
    }

    public static float getSerumChance() {
        return serumChance;
    }

    public static float getSecondSerumChance() {
        return secondSerumChance;
    }

    static {
        spawnConstraint = 100;
        entityConstraint = 1000;
        allowPollination = true;
        spawnRaritys = Maps.newHashMap();
        spawnButterflysFromLeaves = true;
        generateCocoons = false;
        generateCocoonsAmount = 1.0f;
        serumChance = 0.55f;
        secondSerumChance = 0.0f;
    }
}

