/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorSource;
import forestry.core.config.Config;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.IHintSource;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.ledgers.ClimateLedger;
import forestry.core.gui.ledgers.HintLedger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.gui.ledgers.OwnerLedger;
import forestry.core.gui.ledgers.PowerLedger;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.owner.IOwnedTile;
import forestry.core.proxy.Proxies;
import forestry.core.render.FontColour;
import forestry.core.render.ForestryResource;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.IPowerHandler;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;

public abstract class GuiForestry<C extends Container, I extends IInventory>
extends GuiContainer {
    protected final I inventory;
    protected final C container;
    public final ResourceLocation textureFile;
    protected final WidgetManager widgetManager = new WidgetManager(this);
    protected LedgerManager ledgerManager;
    protected TextLayoutHelper textLayout;
    protected FontColour fontColor;

    protected GuiForestry(String texture, C container, I inventory) {
        this(new ForestryResource(texture), container, inventory);
    }

    protected GuiForestry(ResourceLocation texture, C container, I inventory) {
        super(container);
        this.textureFile = texture;
        this.inventory = inventory;
        this.container = container;
        this.fontColor = new FontColour(Proxies.render.getSelectedTexturePack());
        this.textLayout = new TextLayoutHelper(this, this.fontColor);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxLedgerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        this.ledgerManager = new LedgerManager(this, maxLedgerWidth);
        this.addLedgers();
    }

    protected void addLedgers() {
        IHintSource hintSource;
        List<String> hints;
        if (this.inventory instanceof IErrorSource) {
            this.ledgerManager.add((IErrorSource)this.inventory);
        }
        if (this.inventory instanceof IErrorLogicSource) {
            IErrorLogicSource errorLogicSource = (IErrorLogicSource)this.inventory;
            this.ledgerManager.add(errorLogicSource.getErrorLogic());
        }
        if (this.inventory instanceof IClimatised) {
            this.ledgerManager.add(new ClimateLedger(this.ledgerManager, (IClimatised)this.inventory));
        }
        if (Config.enableEnergyStat && this.inventory instanceof IPowerHandler && ((IPowerHandler)this.inventory).getEnergyManager().getMaxEnergyStored() > 0) {
            this.ledgerManager.add(new PowerLedger(this.ledgerManager, (IPowerHandler)this.inventory));
        }
        if (Config.enableHints && this.inventory instanceof IHintSource && (hints = (hintSource = (IHintSource)this.inventory).getHints()) != null && !hints.isEmpty()) {
            this.ledgerManager.add(new HintLedger(this.ledgerManager, hintSource));
        }
        if (this.inventory instanceof IOwnedTile) {
            this.ledgerManager.add(new OwnerLedger(this.ledgerManager, (IOwnedTile)this.inventory));
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.ledgerManager.onGuiClosed();
    }

    public FontColour getFontColor() {
        return this.fontColor;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    protected void func_73864_a(int xPos, int yPos, int mouseButton) throws IOException {
        super.func_73864_a(xPos, yPos, mouseButton);
        this.ledgerManager.handleMouseClicked(xPos, yPos, mouseButton);
        this.widgetManager.handleMouseClicked(xPos, yPos, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.widgetManager.handleMouseRelease(mouseX, mouseY, state);
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long time) {
        this.widgetManager.handleMouseMove(mouseX, mouseY, mouseButton, time);
        super.func_146273_a(mouseX, mouseY, mouseButton, time);
    }

    protected Slot func_146975_c(int par1, int par2) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.isMouseOverSlot(slot, par1, par2)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot par1Slot, int par2, int par3) {
        return this.func_146978_c(par1Slot.field_75223_e, par1Slot.field_75221_f, 16, 16, par2, par3);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.ledgerManager.drawTooltips(mouseX, mouseY);
        InventoryPlayer playerInv = this.field_146297_k.field_71439_g.field_71071_by;
        if (playerInv.func_70445_o() == null) {
            GuiUtil.drawToolTips(this, this.widgetManager.getWidgets(), mouseX, mouseY);
            GuiUtil.drawToolTips(this, this.field_146292_n, mouseX, mouseY);
            GuiUtil.drawToolTips(this, this.field_147002_h.field_75151_b, mouseX, mouseY);
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        this.bindTexture(this.textureFile);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawWidgets();
        GlStateManager.func_179121_F();
        this.bindTexture(this.textureFile);
    }

    protected void drawWidgets() {
        this.ledgerManager.drawLedgers();
        this.widgetManager.drawWidgets();
    }

    protected void bindTexture(ResourceLocation texturePath) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Proxies.render.bindTexture(texturePath);
    }

    public void setZLevel(float level) {
        this.field_73735_i = level;
    }

    public int getSizeX() {
        return this.field_146999_f;
    }

    public int getSizeY() {
        return this.field_147000_g;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public void func_73733_a(int par1, int par2, int par3, int par4, int par5, int par6) {
        super.func_73733_a(par1, par2, par3, par4, par5, par6);
    }

    @Nonnull
    public List<Rectangle> getExtraGuiAreas() {
        return this.ledgerManager.getLedgerAreas();
    }
}

