/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.core.commands.CommandHelpers;
import forestry.core.commands.ICommandModeHelper;
import forestry.core.commands.IStatsSaveHelper;
import forestry.core.commands.SubCommand;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class CommandSaveStats
extends SubCommand {
    private static final String discoveredSymbol = Translator.translateToLocal("for.chat.command.forestry.stats.save.key.discovered.symbol");
    private static final String blacklistedSymbol = Translator.translateToLocal("for.chat.command.forestry.stats.save.key.blacklisted.symbol");
    private static final String notCountedSymbol = Translator.translateToLocal("for.chat.command.forestry.stats.save.key.notCounted.symbol");
    private final IStatsSaveHelper saveHelper;
    private final ICommandModeHelper modeHelper;

    public CommandSaveStats(IStatsSaveHelper saveHelper, ICommandModeHelper modeHelper) {
        super("save");
        this.saveHelper = saveHelper;
        this.modeHelper = modeHelper;
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return CommandHelpers.getListOfStringsMatchingLastWord(args, server.func_71213_z());
    }

    @Override
    public void executeSubCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 1) {
            this.printHelp(sender);
            return;
        }
        String newLine = System.getProperty("line.separator");
        World world = sender.func_130014_f_();
        EntityPlayerMP player = args.length > 0 ? CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]) : CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)sender.func_70005_c_());
        ArrayList<String> statistics = new ArrayList<String>();
        String date = DateFormat.getInstance().format(new Date());
        statistics.add(Translator.translateToLocalFormatted(this.saveHelper.getUnlocalizedSaveStatsString(), player.func_145748_c_(), date));
        statistics.add("");
        statistics.add(Translator.translateToLocalFormatted("for.chat.command.forestry.stats.save.mode", this.modeHelper.getModeName(world)));
        statistics.add("");
        IBreedingTracker tracker = this.saveHelper.getBreedingTracker(world, player.func_146103_bH());
        if (tracker == null) {
            statistics.add(Translator.translateToLocal("for.chat.command.forestry.stats.save.error4"));
        } else {
            this.saveHelper.addExtraInfo(statistics, tracker);
            Collection<IAlleleSpecies> species = this.saveHelper.getSpecies();
            String speciesCount = Translator.translateToLocal("for.gui.speciescount");
            String speciesCountLine = String.format("%s (%s):", speciesCount, species.size());
            statistics.add(speciesCountLine);
            statistics.add(StringUtil.line(speciesCountLine.length()));
            statistics.add(discoveredSymbol + ": " + Translator.translateToLocal("for.chat.command.forestry.stats.save.key.discovered"));
            statistics.add(blacklistedSymbol + ": " + Translator.translateToLocal("for.chat.command.forestry.stats.save.key.blacklisted"));
            statistics.add(notCountedSymbol + ": " + Translator.translateToLocal("for.chat.command.forestry.stats.save.key.notCounted"));
            statistics.add("");
            String header = CommandSaveStats.generateSpeciesListHeader();
            statistics.add(header);
            statistics.add(StringUtil.line(header.length()));
            statistics.add("");
            for (IAlleleSpecies allele : species) {
                statistics.add(CommandSaveStats.generateSpeciesListEntry(allele, tracker));
            }
        }
        File file = new File(Proxies.common.getForestryRoot(), "config/forestry/stats/" + player.getDisplayNameString() + '-' + this.saveHelper.getFileSuffix() + ".log");
        try {
            boolean success;
            File folder = file.getParentFile();
            if (folder != null && !folder.exists() && !(success = file.getParentFile().mkdirs())) {
                CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.stats.save.error1", new Object[0]);
                return;
            }
            if (!file.exists() && !file.createNewFile()) {
                CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.stats.save.error1", new Object[0]);
                return;
            }
            if (!file.canWrite()) {
                CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.stats.save.error2", new Object[0]);
                return;
            }
            FileOutputStream fileout = new FileOutputStream(file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileout, "UTF-8"));
            writer.write("# forestry" + newLine + "# " + "5.2.9.240" + newLine);
            for (String line : statistics) {
                writer.write(line + newLine);
            }
            writer.close();
        }
        catch (IOException ex) {
            CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.stats.save.error3", new Object[0]);
            Log.error(Translator.translateToLocal("for.for.chat.command.forestry.stats.save.error3"), ex);
            return;
        }
        CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.stats.save.saved", player.func_145748_c_());
    }

    private static String generateSpeciesListHeader() {
        String authority = Translator.translateToLocal("for.gui.alyzer.authority");
        String species = Translator.translateToLocal("for.gui.species");
        return CommandSaveStats.speciesListEntry(discoveredSymbol, blacklistedSymbol, notCountedSymbol, "UID", species, authority);
    }

    private static String generateSpeciesListEntry(IAlleleSpecies species, IBreedingTracker tracker) {
        String discovered = "";
        if (tracker.isDiscovered(species)) {
            discovered = discoveredSymbol;
        }
        String blacklisted = "";
        if (AlleleManager.alleleRegistry.isBlacklisted(species.getUID())) {
            blacklisted = blacklistedSymbol;
        }
        String notCounted = "";
        if (!species.isCounted()) {
            notCounted = notCountedSymbol;
        }
        return CommandSaveStats.speciesListEntry(discovered, blacklisted, notCounted, species.getUID(), species.getName(), species.getAuthority());
    }

    private static String speciesListEntry(String discovered, String blacklisted, String notCounted, String UID, String speciesName, String authority) {
        return String.format("[ %-2s ] [ %-2s ] [ %-2s ]\t%-40s %-20s %-20s", discovered, blacklisted, notCounted, UID, speciesName, authority);
    }
}

