/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.arboriculture.worldgen;

import javax.annotation.Nonnull;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import forestry.api.world.ITreeGenData;
import forestry.core.worldgen.WorldGenHelper;

public class WorldGenIpe extends WorldGenTree {

	public WorldGenIpe(ITreeGenData tree) {
		super(tree, 6, 4);
	}

	@Nonnull
	@Override
	public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
		WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, height, girth, 0, 0, null, 0);

		int trunkSpawn = height - 2;
		float adjustedGirth = girth * .65f;

		Set<BlockPos> branchCoords = new HashSet<>();
		while (trunkSpawn > 2) {
			int radius = Math.round(adjustedGirth * (height - trunkSpawn) / 1.5f);
			branchCoords.addAll(WorldGenHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, trunkSpawn, 0), girth, 0.25f, 0.25f, radius, 2, 1.0f));
			trunkSpawn -= 2;
		}
		return branchCoords;
	}

	@Override
	protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
		int leafSpawn = height + 1;
		float adjustedGirth = girth * .65f;

		WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), girth, girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
		WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), girth, 0.2f * adjustedGirth + girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
		WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn, 0), girth, 0.2f * adjustedGirth + girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);

		for (BlockPos branchEnd : branchEnds) {
			WorldGenHelper.generateCylinderFromPos(world, leaf, branchEnd, 2.0f + girth, 2, WorldGenHelper.EnumReplaceMode.AIR);
		}
	}
}
